/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.type.BitWiseOpEnum;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprBitWiseNode
extends ExprNodeBase
implements ExprEvaluator {
    private final BitWiseOpEnum bitWiseOpEnum;
    private transient BitWiseOpEnum.Computer bitWiseOpEnumComputer;
    private Class resultType;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = 9035943176810365437L;
    private static final Logger log = LoggerFactory.getLogger(ExprBitWiseNode.class);

    public ExprBitWiseNode(BitWiseOpEnum bitWiseOpEnum) {
        this.bitWiseOpEnum = bitWiseOpEnum;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public BitWiseOpEnum getBitWiseOpEnum() {
        return this.bitWiseOpEnum;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class childBoxedTypeTwo;
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("BitWise node must have 2 parameters");
        }
        for (ExprEvaluator child : this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes())) {
            Class childType = child.getType();
            if (JavaClassHelper.isBoolean(childType) || JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Invalid datatype for bitwise " + childType.getName() + " is not allowed");
        }
        Class childTypeOne = this.evaluators[0].getType();
        Class childTypeTwo = this.evaluators[1].getType();
        if (JavaClassHelper.isFloatingPointClass(childTypeOne) || JavaClassHelper.isFloatingPointClass(childTypeTwo)) {
            throw new ExprValidationException("Invalid type for bitwise " + this.bitWiseOpEnum.getComputeDescription() + " operator");
        }
        Class childBoxedTypeOne = JavaClassHelper.getBoxedType(childTypeOne);
        if (childBoxedTypeOne != (childBoxedTypeTwo = JavaClassHelper.getBoxedType(childTypeTwo))) {
            throw new ExprValidationException("Bitwise expressions must be of the same type for bitwise " + this.bitWiseOpEnum.getComputeDescription() + " operator");
        }
        this.resultType = childBoxedTypeOne;
        this.bitWiseOpEnumComputer = this.bitWiseOpEnum.getComputer(this.resultType);
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueChildOne = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object valueChildTwo = this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueChildOne == null || valueChildTwo == null) {
            return null;
        }
        return this.bitWiseOpEnumComputer.compute(valueChildOne, valueChildTwo);
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprBitWiseNode)) {
            return false;
        }
        ExprBitWiseNode other = (ExprBitWiseNode)node;
        return other.bitWiseOpEnum == this.bitWiseOpEnum;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        writer.append(this.bitWiseOpEnum.getComputeDescription());
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.BITWISE;
    }
}

