/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.util.Map;

public class ExprEqualsNodeImpl
extends ExprNodeBase
implements ExprEqualsNode {
    private final boolean isNotEquals;
    private final boolean isIs;
    private transient ExprEvaluator evaluator;
    private static final long serialVersionUID = 5504809379222369952L;

    public ExprEqualsNodeImpl(boolean isNotEquals, boolean isIs) {
        this.isNotEquals = isNotEquals;
        this.isIs = isIs;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    @Override
    public boolean isNotEquals() {
        return this.isNotEquals;
    }

    @Override
    public boolean isIs() {
        return this.isIs;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class coercionType;
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Invalid use of equals, expecting left-hand side and right-hand side but received " + this.getChildNodes().length + " expressions");
        }
        ExprEvaluator[] evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class typeOne = JavaClassHelper.getBoxedType(evaluators[0].getType());
        Class typeTwo = JavaClassHelper.getBoxedType(evaluators[1].getType());
        if (typeOne == null || typeTwo == null) {
            this.evaluator = this.getEvaluator(evaluators[0], evaluators[1]);
            return null;
        }
        if (typeOne.equals(typeTwo) || typeOne.isAssignableFrom(typeTwo)) {
            this.evaluator = this.getEvaluator(evaluators[0], evaluators[1]);
            return null;
        }
        try {
            coercionType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to '" + typeOne.getSimpleName() + "' is not allowed");
        }
        if (coercionType == JavaClassHelper.getBoxedType(typeOne) && coercionType == JavaClassHelper.getBoxedType(typeTwo)) {
            this.evaluator = this.getEvaluator(evaluators[0], evaluators[1]);
        } else {
            if (!JavaClassHelper.isNumeric(coercionType)) {
                throw new ExprValidationException("Cannot convert datatype '" + coercionType.getName() + "' to a numeric value");
            }
            SimpleNumberCoercer numberCoercerLHS = SimpleNumberCoercerFactory.getCoercer(typeOne, coercionType);
            SimpleNumberCoercer numberCoercerRHS = SimpleNumberCoercerFactory.getCoercer(typeTwo, coercionType);
            this.evaluator = new ExprEqualsEvaluatorCoercing(this, evaluators[0], evaluators[1], numberCoercerLHS, numberCoercerRHS);
        }
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        if (this.isIs) {
            writer.append(" is ");
            if (this.isNotEquals) {
                writer.append("not ");
            }
        } else if (!this.isNotEquals) {
            writer.append("=");
        } else {
            writer.append("!=");
        }
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.EQUALS;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprEqualsNode)) {
            return false;
        }
        ExprEqualsNode other = (ExprEqualsNode)node;
        return other.isNotEquals() == this.isNotEquals;
    }

    private ExprEvaluator getEvaluator(ExprEvaluator lhs, ExprEvaluator rhs) {
        if (this.isIs) {
            return new ExprEqualsEvaluatorIs(this, lhs, rhs);
        }
        return new ExprEqualsEvaluatorEquals(this, lhs, rhs);
    }

    public static class ExprEqualsEvaluatorIs
    implements ExprEvaluator {
        private transient ExprEqualsNodeImpl parent;
        private transient ExprEvaluator lhs;
        private transient ExprEvaluator rhs;

        public ExprEqualsEvaluatorIs(ExprEqualsNodeImpl parent, ExprEvaluator lhs, ExprEvaluator rhs) {
            this.parent = parent;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Object leftResult = this.lhs.evaluate(eventsPerStream, isNewData, context);
            Object rightResult = this.rhs.evaluate(eventsPerStream, isNewData, context);
            if (leftResult == null) {
                return rightResult == null ^ this.parent.isNotEquals;
            }
            return (rightResult != null && leftResult.equals(rightResult)) ^ this.parent.isNotEquals;
        }

        @Override
        public Class getType() {
            return Boolean.class;
        }
    }

    public static class ExprEqualsEvaluatorEquals
    implements ExprEvaluator {
        private transient ExprEqualsNodeImpl parent;
        private transient ExprEvaluator lhs;
        private transient ExprEvaluator rhs;

        public ExprEqualsEvaluatorEquals(ExprEqualsNodeImpl parent, ExprEvaluator lhs, ExprEvaluator rhs) {
            this.parent = parent;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Object leftResult = this.lhs.evaluate(eventsPerStream, isNewData, context);
            Object rightResult = this.rhs.evaluate(eventsPerStream, isNewData, context);
            if (leftResult == null || rightResult == null) {
                return null;
            }
            return leftResult.equals(rightResult) ^ this.parent.isNotEquals();
        }

        @Override
        public Class getType() {
            return Boolean.class;
        }
    }

    public static class ExprEqualsEvaluatorCoercing
    implements ExprEvaluator {
        private transient ExprEqualsNodeImpl parent;
        private transient ExprEvaluator lhs;
        private transient ExprEvaluator rhs;
        private transient SimpleNumberCoercer numberCoercerLHS;
        private transient SimpleNumberCoercer numberCoercerRHS;

        public ExprEqualsEvaluatorCoercing(ExprEqualsNodeImpl parent, ExprEvaluator lhs, ExprEvaluator rhs, SimpleNumberCoercer numberCoercerLHS, SimpleNumberCoercer numberCoercerRHS) {
            this.parent = parent;
            this.lhs = lhs;
            this.rhs = rhs;
            this.numberCoercerLHS = numberCoercerLHS;
            this.numberCoercerRHS = numberCoercerRHS;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Boolean result = this.evaluateInternal(eventsPerStream, isNewData, context);
            return result;
        }

        private Boolean evaluateInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Object leftResult = this.lhs.evaluate(eventsPerStream, isNewData, context);
            Object rightResult = this.rhs.evaluate(eventsPerStream, isNewData, context);
            if (!this.parent.isIs) {
                if (leftResult == null || rightResult == null) {
                    return null;
                }
            } else {
                if (leftResult == null) {
                    return rightResult == null;
                }
                if (rightResult == null) {
                    return false;
                }
            }
            Number left = this.numberCoercerLHS.coerceBoxed((Number)leftResult);
            Number right = this.numberCoercerRHS.coerceBoxed((Number)rightResult);
            return left.equals(right) ^ this.parent.isNotEquals;
        }

        @Override
        public Class getType() {
            return Boolean.class;
        }
    }
}

