/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprInNode;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ExprInNodeImpl
extends ExprNodeBase
implements ExprEvaluator,
ExprInNode {
    private final boolean isNotIn;
    private boolean mustCoerce;
    private boolean hasCollectionOrArray;
    private transient SimpleNumberCoercer coercer;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -601723009914169907L;

    public ExprInNodeImpl(boolean isNotIn) {
        this.isNotIn = isNotIn;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isNotIn() {
        return this.isNotIn;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.validateWithoutContext();
        return null;
    }

    @Override
    public void validateWithoutContext() throws ExprValidationException {
        Class coercionType;
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("The IN operator requires at least 2 child expressions");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class typeOne = JavaClassHelper.getBoxedType(this.evaluators[0].getType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        ArrayList<Class> comparedTypes = new ArrayList<Class>();
        comparedTypes.add(typeOne);
        this.hasCollectionOrArray = false;
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            Class propType = this.evaluators[i + 1].getType();
            if (propType == null) continue;
            if (propType.isArray()) {
                this.hasCollectionOrArray = true;
                if (propType.getComponentType() == Object.class) continue;
                comparedTypes.add(propType.getComponentType());
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Collection.class)) {
                this.hasCollectionOrArray = true;
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Map.class)) {
                this.hasCollectionOrArray = true;
                continue;
            }
            comparedTypes.add(propType);
        }
        try {
            coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        this.mustCoerce = false;
        if (JavaClassHelper.isNumeric(coercionType)) {
            for (Class compareType : comparedTypes) {
                if (coercionType == JavaClassHelper.getBoxedType(compareType)) continue;
                this.mustCoerce = true;
            }
            if (this.mustCoerce) {
                this.coercer = SimpleNumberCoercerFactory.getCoercer(null, JavaClassHelper.getBoxedType(coercionType));
            }
        }
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean result = this.evaluateInternal(eventsPerStream, isNewData, exprEvaluatorContext);
        return result;
    }

    private Boolean evaluateInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object inPropResult = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (!this.hasCollectionOrArray) {
            int len;
            if (this.mustCoerce && inPropResult != null) {
                inPropResult = this.coercer.coerceBoxed((Number)inPropResult);
            }
            if ((len = this.getChildNodes().length - 1) > 0 && inPropResult == null) {
                return null;
            }
            boolean hasNullRow = false;
            for (int i = 1; i <= len; ++i) {
                Number right;
                Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (rightResult == null) {
                    hasNullRow = true;
                    continue;
                }
                if (!(!this.mustCoerce ? rightResult.equals(inPropResult) : (right = this.coercer.coerceBoxed((Number)rightResult)).equals(inPropResult))) continue;
                return !this.isNotIn;
            }
            if (hasNullRow) {
                return null;
            }
            return this.isNotIn;
        }
        int len = this.getChildNodes().length - 1;
        boolean hasNullRow = false;
        for (int i = 1; i <= len; ++i) {
            Number right;
            Number left;
            Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (rightResult == null) continue;
            if (rightResult instanceof Collection) {
                if (inPropResult == null) {
                    return null;
                }
                Collection coll = (Collection)rightResult;
                if (!coll.contains(inPropResult)) continue;
                return !this.isNotIn;
            }
            if (rightResult instanceof Map) {
                if (inPropResult == null) {
                    return null;
                }
                Map coll = (Map)rightResult;
                if (!coll.containsKey(inPropResult)) continue;
                return !this.isNotIn;
            }
            if (rightResult.getClass().isArray()) {
                int arrayLength = Array.getLength(rightResult);
                if (arrayLength > 0 && inPropResult == null) {
                    return null;
                }
                for (int index = 0; index < arrayLength; ++index) {
                    Number right2;
                    Number left2;
                    Object item = Array.get(rightResult, index);
                    if (item == null) {
                        hasNullRow = true;
                        continue;
                    }
                    if (!(!this.mustCoerce ? inPropResult.equals(item) : item instanceof Number && (left2 = this.coercer.coerceBoxed((Number)inPropResult)).equals(right2 = this.coercer.coerceBoxed((Number)item)))) continue;
                    return !this.isNotIn;
                }
                continue;
            }
            if (inPropResult == null) {
                return null;
            }
            if (!(!this.mustCoerce ? inPropResult.equals(rightResult) : (left = this.coercer.coerceBoxed((Number)inPropResult)).equals(right = this.coercer.coerceBoxed((Number)rightResult)))) continue;
            return !this.isNotIn;
        }
        if (hasNullRow) {
            return null;
        }
        return this.isNotIn;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprInNodeImpl)) {
            return false;
        }
        ExprInNodeImpl other = (ExprInNodeImpl)node;
        return other.isNotIn == this.isNotIn;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        Iterator<ExprNode> it = Arrays.asList(this.getChildNodes()).iterator();
        it.next().toEPL(writer, this.getPrecedence());
        if (this.isNotIn) {
            writer.append(" not in (");
        } else {
            writer.append(" in (");
        }
        do {
            ExprNode inSetValueExpr = it.next();
            writer.append(delimiter);
            inSetValueExpr.toEPL(writer, this.getPrecedence());
            delimiter = ",";
        } while (it.hasNext());
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }
}

