/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.type.MathArithTypeEnum;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.math.BigDecimal;

public class ExprMathNode
extends ExprNodeBase
implements ExprEvaluator {
    private final MathArithTypeEnum mathArithTypeEnum;
    private final boolean isIntegerDivision;
    private final boolean isDivisionByZeroReturnsNull;
    private transient MathArithTypeEnum.Computer arithTypeEnumComputer;
    private Class resultType;
    private transient ExprEvaluator evaluatorLeft;
    private transient ExprEvaluator evaluatorRight;
    private static final long serialVersionUID = 6479683588602862158L;

    public ExprMathNode(MathArithTypeEnum mathArithTypeEnum, boolean isIntegerDivision, boolean isDivisionByZeroReturnsNull) {
        this.mathArithTypeEnum = mathArithTypeEnum;
        this.isIntegerDivision = isIntegerDivision;
        this.isDivisionByZeroReturnsNull = isDivisionByZeroReturnsNull;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Arithmatic node must have 2 parameters");
        }
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getExprEvaluator().getType();
            if (JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed");
        }
        this.evaluatorLeft = this.getChildNodes()[0].getExprEvaluator();
        this.evaluatorRight = this.getChildNodes()[1].getExprEvaluator();
        Class childTypeOne = this.evaluatorLeft.getType();
        Class childTypeTwo = this.evaluatorRight.getType();
        this.resultType = !(childTypeOne != Short.TYPE && childTypeOne != Short.class || childTypeTwo != Short.TYPE && childTypeTwo != Short.class) ? Integer.class : (!(childTypeOne != Byte.TYPE && childTypeOne != Byte.class || childTypeTwo != Byte.TYPE && childTypeTwo != Byte.class) ? Integer.class : (childTypeOne.equals(childTypeTwo) ? JavaClassHelper.getBoxedType(childTypeTwo) : JavaClassHelper.getArithmaticCoercionType(childTypeOne, childTypeTwo)));
        if (this.mathArithTypeEnum == MathArithTypeEnum.DIVIDE && !this.isIntegerDivision && this.resultType != BigDecimal.class) {
            this.resultType = Double.class;
        }
        this.arithTypeEnumComputer = this.mathArithTypeEnum.getComputer(this.resultType, childTypeOne, childTypeTwo, this.isIntegerDivision, this.isDivisionByZeroReturnsNull, validationContext.getEngineImportService().getDefaultMathContext());
        return null;
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueChildOne = this.evaluatorLeft.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueChildOne == null) {
            return null;
        }
        Object valueChildTwo = this.evaluatorRight.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueChildTwo == null) {
            return null;
        }
        return this.arithTypeEnumComputer.compute((Number)valueChildOne, (Number)valueChildTwo);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        writer.append(this.mathArithTypeEnum.getExpressionText());
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        if (this.mathArithTypeEnum == MathArithTypeEnum.MULTIPLY || this.mathArithTypeEnum == MathArithTypeEnum.DIVIDE || this.mathArithTypeEnum == MathArithTypeEnum.MODULO) {
            return ExprPrecedenceEnum.MULTIPLY;
        }
        return ExprPrecedenceEnum.ADDITIVE;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprMathNode)) {
            return false;
        }
        ExprMathNode other = (ExprMathNode)node;
        return other.mathArithTypeEnum == this.mathArithTypeEnum;
    }

    public MathArithTypeEnum getMathArithTypeEnum() {
        return this.mathArithTypeEnum;
    }
}

