/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprRelationalOpNode;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprRelationalOpNodeImpl
extends ExprNodeBase
implements ExprEvaluator,
ExprRelationalOpNode {
    private final RelationalOpEnum relationalOpEnum;
    private transient RelationalOpEnum.Computer computer;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -6170161542681634598L;

    public ExprRelationalOpNodeImpl(RelationalOpEnum relationalOpEnum) {
        this.relationalOpEnum = relationalOpEnum;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public RelationalOpEnum getRelationalOpEnum() {
        return this.relationalOpEnum;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new IllegalStateException("Relational op node does not have exactly 2 parameters");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class typeOne = JavaClassHelper.getBoxedType(this.evaluators[0].getType());
        Class typeTwo = JavaClassHelper.getBoxedType(this.evaluators[1].getType());
        if (typeOne != String.class || typeTwo != String.class) {
            if (!JavaClassHelper.isNumeric(typeOne)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
            }
            if (!JavaClassHelper.isNumeric(typeTwo)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
            }
        }
        Class compareType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        this.computer = this.relationalOpEnum.getComputer(compareType, typeOne, typeTwo);
        return null;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueLeft = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueLeft == null) {
            return null;
        }
        Object valueRight = this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueRight == null) {
            return null;
        }
        return this.computer.compare(valueLeft, valueRight);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        writer.append(this.relationalOpEnum.getExpressionText());
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprRelationalOpNodeImpl)) {
            return false;
        }
        ExprRelationalOpNodeImpl other = (ExprRelationalOpNodeImpl)node;
        return other.relationalOpEnum == this.relationalOpEnum;
    }
}

