/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.prev;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.rowregex.RegexExprPreviousEvalStrategy;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccess;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprPreviousMatchRecognizeNode
extends ExprNodeBase
implements ExprEvaluator {
    private static final long serialVersionUID = 0L;
    private Class resultType;
    private int streamNumber;
    private Integer constantIndexNumber;
    private transient RegexExprPreviousEvalStrategy strategy;
    private transient ExprEvaluator evaluator;
    private int assignedIndex;

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Match-Recognize Previous expression must have 2 parameters");
        }
        if (!(this.getChildNodes()[0] instanceof ExprIdentNode)) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an property identifier as the first parameter");
        }
        if (!this.getChildNodes()[1].isConstantResult() || !JavaClassHelper.isNumericNonFP(this.getChildNodes()[1].getExprEvaluator().getType())) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an integer index parameter or expression as the second parameter");
        }
        ExprNode constantNode = this.getChildNodes()[1];
        Object value = constantNode.getExprEvaluator().evaluate(null, false, validationContext.getExprEvaluatorContext());
        if (!(value instanceof Number)) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an integer index parameter or expression as the second parameter");
        }
        this.constantIndexNumber = ((Number)value).intValue();
        ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes()[0];
        this.streamNumber = identNode.getStreamId();
        this.evaluator = this.getChildNodes()[0].getExprEvaluator();
        this.resultType = this.evaluator.getType();
        return null;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public Integer getConstantIndexNumber() {
        if (this.constantIndexNumber == null) {
            ExprNode constantNode = this.getChildNodes()[1];
            Object value = constantNode.getExprEvaluator().evaluate(null, false, null);
            this.constantIndexNumber = ((Number)value).intValue();
        }
        return this.constantIndexNumber;
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        RegexPartitionStateRandomAccess access = this.strategy.getAccess(exprEvaluatorContext);
        EventBean substituteEvent = access.getPreviousEvent(this.assignedIndex);
        if (substituteEvent == null) {
            return null;
        }
        EventBean originalEvent = eventsPerStream[this.streamNumber];
        eventsPerStream[this.streamNumber] = substituteEvent;
        Object evalResult = this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        eventsPerStream[this.streamNumber] = originalEvent;
        return evalResult;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append("prev(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        writer.append(',');
        this.getChildNodes()[1].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprPreviousMatchRecognizeNode;
    }

    public void setAssignedIndex(int assignedIndex) {
        this.assignedIndex = assignedIndex;
    }

    public void setStrategy(RegexExprPreviousEvalStrategy strategy) {
        this.strategy = strategy;
    }
}

