/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstFactory;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaResult;
import com.espertech.esper.epl.expression.time.ExprTimePeriodImpl;
import com.espertech.esper.epl.expression.time.ExprTimePeriodUtil;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import java.util.Calendar;
import java.util.TimeZone;

public class ExprTimePeriodEvalDeltaConstGivenCalAdd
implements ExprTimePeriodEvalDeltaConst,
ExprTimePeriodEvalDeltaConstFactory {
    private final Calendar cal;
    private final ExprTimePeriodImpl.TimePeriodAdder[] adders;
    private final int[] added;
    private final TimeAbacus timeAbacus;
    private final int indexMicroseconds;

    public ExprTimePeriodEvalDeltaConstGivenCalAdd(ExprTimePeriodImpl.TimePeriodAdder[] adders, int[] added, TimeZone timeZone, TimeAbacus timeAbacus) {
        this.adders = adders;
        this.added = added;
        this.cal = Calendar.getInstance(timeZone);
        this.timeAbacus = timeAbacus;
        this.indexMicroseconds = ExprTimePeriodUtil.findIndexMicroseconds(adders);
    }

    @Override
    public ExprTimePeriodEvalDeltaConst make(String validateMsgName, String validateMsgValue, AgentInstanceContext agentInstanceContext) {
        return this;
    }

    @Override
    public boolean equalsTimePeriod(ExprTimePeriodEvalDeltaConst otherComputation) {
        if (otherComputation instanceof ExprTimePeriodEvalDeltaConstGivenCalAdd) {
            ExprTimePeriodEvalDeltaConstGivenCalAdd other = (ExprTimePeriodEvalDeltaConstGivenCalAdd)otherComputation;
            if (other.adders.length != this.adders.length) {
                return false;
            }
            for (int i = 0; i < this.adders.length; ++i) {
                if (this.added[i] == other.added[i] && this.adders[i].getClass() == other.adders[i].getClass()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized long deltaAdd(long fromTime) {
        long target = this.addSubtract(fromTime, 1);
        return target - fromTime;
    }

    @Override
    public synchronized long deltaSubtract(long fromTime) {
        long target = this.addSubtract(fromTime, -1);
        return fromTime - target;
    }

    @Override
    public ExprTimePeriodEvalDeltaResult deltaAddWReference(long fromTime, long reference) {
        long last;
        if (reference > fromTime) {
            while (reference > fromTime) {
                reference -= this.deltaSubtract(reference);
            }
        }
        long next = reference;
        while ((next += this.deltaAdd(last = next)) <= fromTime) {
        }
        return new ExprTimePeriodEvalDeltaResult(next - fromTime, last);
    }

    private long addSubtract(long fromTime, int factor) {
        long remainder = this.timeAbacus.calendarSet(fromTime, this.cal);
        for (int i = 0; i < this.adders.length; ++i) {
            this.adders[i].add(this.cal, factor * this.added[i]);
        }
        long result = this.timeAbacus.calendarGet(this.cal, remainder);
        if (this.indexMicroseconds != -1) {
            result += (long)(factor * this.added[this.indexMicroseconds]);
        }
        return result;
    }
}

