/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.util.TimePeriod;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprVariableNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstGivenCalAdd;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstGivenDelta;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConstCalAdd;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConstMsec;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.TimeZone;

public class ExprTimePeriodImpl
extends ExprNodeBase
implements ExprTimePeriod,
ExprEvaluator {
    private final TimeZone timeZone;
    private final boolean hasYear;
    private final boolean hasMonth;
    private final boolean hasWeek;
    private final boolean hasDay;
    private final boolean hasHour;
    private final boolean hasMinute;
    private final boolean hasSecond;
    private final boolean hasMillisecond;
    private final boolean hasMicrosecond;
    private boolean hasVariable;
    private transient ExprEvaluator[] evaluators;
    private transient TimePeriodAdder[] adders;
    private final TimeAbacus timeAbacus;
    private static final long serialVersionUID = -7229827032500659319L;

    public ExprTimePeriodImpl(TimeZone timeZone, boolean hasYear, boolean hasMonth, boolean hasWeek, boolean hasDay, boolean hasHour, boolean hasMinute, boolean hasSecond, boolean hasMillisecond, boolean hasMicrosecond, TimeAbacus timeAbacus) {
        this.timeZone = timeZone;
        this.hasYear = hasYear;
        this.hasMonth = hasMonth;
        this.hasWeek = hasWeek;
        this.hasDay = hasDay;
        this.hasHour = hasHour;
        this.hasMinute = hasMinute;
        this.hasSecond = hasSecond;
        this.hasMillisecond = hasMillisecond;
        this.hasMicrosecond = hasMicrosecond;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public ExprTimePeriodEvalDeltaConst constEvaluator(ExprEvaluatorContext context) {
        if (!this.hasMonth && !this.hasYear) {
            double seconds = this.evaluateAsSeconds(null, true, context);
            long msec = this.timeAbacus.deltaForSecondsDouble(seconds);
            return new ExprTimePeriodEvalDeltaConstGivenDelta(msec);
        }
        int[] values = new int[this.adders.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = ((Number)this.evaluators[i].evaluate(null, true, context)).intValue();
        }
        return new ExprTimePeriodEvalDeltaConstGivenCalAdd(this.adders, values, this.timeZone, this.timeAbacus);
    }

    @Override
    public ExprTimePeriodEvalDeltaNonConst nonconstEvaluator() {
        if (!this.hasMonth && !this.hasYear) {
            return new ExprTimePeriodEvalDeltaNonConstMsec(this);
        }
        return new ExprTimePeriodEvalDeltaNonConstCalAdd(this.timeZone, this);
    }

    public TimeAbacus getTimeAbacus() {
        return this.timeAbacus;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        throw new IllegalStateException("Time-Period expression must be evaluated via any of " + ExprTimePeriod.class.getSimpleName() + " interface methods");
    }

    protected TimePeriodAdder[] getAdders() {
        return this.adders;
    }

    public ExprEvaluator[] getEvaluators() {
        return this.evaluators;
    }

    @Override
    public boolean isHasDay() {
        return this.hasDay;
    }

    @Override
    public boolean isHasHour() {
        return this.hasHour;
    }

    @Override
    public boolean isHasMinute() {
        return this.hasMinute;
    }

    @Override
    public boolean isHasSecond() {
        return this.hasSecond;
    }

    @Override
    public boolean isHasMillisecond() {
        return this.hasMillisecond;
    }

    @Override
    public boolean isHasMicrosecond() {
        return this.hasMicrosecond;
    }

    @Override
    public boolean isHasYear() {
        return this.hasYear;
    }

    @Override
    public boolean isHasMonth() {
        return this.hasMonth;
    }

    @Override
    public boolean isHasWeek() {
        return this.hasWeek;
    }

    @Override
    public boolean hasVariable() {
        return this.hasVariable;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        for (ExprNode childNode : this.getChildNodes()) {
            this.validate(childNode);
        }
        ArrayDeque<TimePeriodAdder> list = new ArrayDeque<TimePeriodAdder>();
        if (this.hasYear) {
            list.add(new TimePeriodAdderYear());
        }
        if (this.hasMonth) {
            list.add(new TimePeriodAdderMonth());
        }
        if (this.hasWeek) {
            list.add(new TimePeriodAdderWeek());
        }
        if (this.hasDay) {
            list.add(new TimePeriodAdderDay());
        }
        if (this.hasHour) {
            list.add(new TimePeriodAdderHour());
        }
        if (this.hasMinute) {
            list.add(new TimePeriodAdderMinute());
        }
        if (this.hasSecond) {
            list.add(new TimePeriodAdderSecond());
        }
        if (this.hasMillisecond) {
            list.add(new TimePeriodAdderMSec());
        }
        if (this.hasMicrosecond) {
            list.add(new TimePeriodAdderUSec());
        }
        this.adders = list.toArray(new TimePeriodAdder[list.size()]);
        return null;
    }

    private void validate(ExprNode expression) throws ExprValidationException {
        if (expression == null) {
            return;
        }
        Class returnType = expression.getExprEvaluator().getType();
        if (!JavaClassHelper.isNumeric(returnType)) {
            throw new ExprValidationException("Time period expression requires a numeric parameter type");
        }
        if ((this.hasMonth || this.hasYear) && JavaClassHelper.getBoxedType(returnType) != Integer.class) {
            throw new ExprValidationException("Time period expressions with month or year component require integer values, received a " + returnType.getSimpleName() + " value");
        }
        if (expression instanceof ExprVariableNode) {
            this.hasVariable = true;
        }
    }

    @Override
    public double evaluateAsSeconds(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        double seconds = 0.0;
        for (int i = 0; i < this.adders.length; ++i) {
            Double result = this.eval(this.evaluators[i], eventsPerStream, newData, context);
            if (result == null) {
                throw new EPException("Failed to evaluate time period, received a null value for '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this) + "'");
            }
            seconds += this.adders[i].compute(result);
        }
        return seconds;
    }

    private Double eval(ExprEvaluator expr, EventBean[] events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object value = expr.evaluate(events, isNewData, exprEvaluatorContext);
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof BigInteger) {
            return ((Number)value).doubleValue();
        }
        return ((Number)value).doubleValue();
    }

    @Override
    public TimePeriod evaluateGetTimePeriod(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        int exprCtr = 0;
        Integer year = null;
        if (this.hasYear) {
            year = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer month = null;
        if (this.hasMonth) {
            month = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer week = null;
        if (this.hasWeek) {
            week = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer day = null;
        if (this.hasDay) {
            day = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer hours = null;
        if (this.hasHour) {
            hours = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer minutes = null;
        if (this.hasMinute) {
            minutes = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer seconds = null;
        if (this.hasSecond) {
            seconds = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer milliseconds = null;
        if (this.hasMillisecond) {
            milliseconds = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer microseconds = null;
        if (this.hasMicrosecond) {
            microseconds = this.getInt(this.evaluators[exprCtr].evaluate(eventsPerStream, newData, context));
        }
        return new TimePeriod(year, month, week, day, hours, minutes, seconds, milliseconds, microseconds);
    }

    private Integer getInt(Object evaluated) {
        if (evaluated == null) {
            return null;
        }
        return ((Number)evaluated).intValue();
    }

    @Override
    public Class getType() {
        return Double.class;
    }

    @Override
    public boolean isConstantResult() {
        for (ExprNode child : this.getChildNodes()) {
            if (child.isConstantResult()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        int exprCtr = 0;
        String delimiter = "";
        if (this.hasYear) {
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" years");
            delimiter = " ";
        }
        if (this.hasMonth) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" months");
            delimiter = " ";
        }
        if (this.hasWeek) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" weeks");
            delimiter = " ";
        }
        if (this.hasDay) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" days");
            delimiter = " ";
        }
        if (this.hasHour) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" hours");
            delimiter = " ";
        }
        if (this.hasMinute) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" minutes");
            delimiter = " ";
        }
        if (this.hasSecond) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" seconds");
            delimiter = " ";
        }
        if (this.hasMillisecond) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" milliseconds");
            delimiter = " ";
        }
        if (this.hasMicrosecond) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr].toEPL(writer, this.getPrecedence());
            writer.append(" microseconds");
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprTimePeriodImpl)) {
            return false;
        }
        ExprTimePeriodImpl other = (ExprTimePeriodImpl)node;
        if (this.hasYear != other.hasYear) {
            return false;
        }
        if (this.hasMonth != other.hasMonth) {
            return false;
        }
        if (this.hasWeek != other.hasWeek) {
            return false;
        }
        if (this.hasDay != other.hasDay) {
            return false;
        }
        if (this.hasHour != other.hasHour) {
            return false;
        }
        if (this.hasMinute != other.hasMinute) {
            return false;
        }
        if (this.hasSecond != other.hasSecond) {
            return false;
        }
        if (this.hasMillisecond != other.hasMillisecond) {
            return false;
        }
        return this.hasMicrosecond == other.hasMicrosecond;
    }

    public static class TimePeriodAdderUSec
    implements TimePeriodAdder {
        @Override
        public double compute(Double value) {
            return value / 1000000.0;
        }

        @Override
        public void add(Calendar cal, int value) {
        }

        @Override
        public boolean isMicroseconds() {
            return true;
        }
    }

    public static class TimePeriodAdderMSec
    implements TimePeriodAdder {
        @Override
        public double compute(Double value) {
            return value / 1000.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(14, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }
    }

    public static class TimePeriodAdderSecond
    implements TimePeriodAdder {
        @Override
        public double compute(Double value) {
            return value;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(13, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }
    }

    public static class TimePeriodAdderMinute
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 60.0;

        @Override
        public double compute(Double value) {
            return value * 60.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(12, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }
    }

    public static class TimePeriodAdderHour
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 3600.0;

        @Override
        public double compute(Double value) {
            return value * 3600.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(11, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }
    }

    public static class TimePeriodAdderDay
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 86400.0;

        @Override
        public double compute(Double value) {
            return value * 86400.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(5, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }
    }

    public static class TimePeriodAdderWeek
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 604800.0;

        @Override
        public double compute(Double value) {
            return value * 604800.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(3, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }
    }

    public static class TimePeriodAdderMonth
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 2592000.0;

        @Override
        public double compute(Double value) {
            return value * 2592000.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(2, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }
    }

    public static class TimePeriodAdderYear
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 3.1536E7;

        @Override
        public double compute(Double value) {
            return value * 3.1536E7;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(1, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }
    }

    public static interface TimePeriodAdder {
        public double compute(Double var1);

        public void add(Calendar var1, int var2);

        public boolean isMicroseconds();
    }
}

