/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.index.quadtree;

import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.index.quadtree.AdvancedIndexConfigContextPartitionQuadTree;
import com.espertech.esper.epl.index.service.AdvancedIndexEvaluationHelper;
import com.espertech.esper.epl.index.service.AdvancedIndexFactoryProvider;
import com.espertech.esper.epl.index.service.AdvancedIndexValidationHelper;
import com.espertech.esper.epl.lookup.AdvancedIndexConfigContextPartition;

public abstract class AdvancedIndexFactoryProviderQuadTree
implements AdvancedIndexFactoryProvider {
    @Override
    public AdvancedIndexConfigContextPartition validateConfigureFilterIndex(String indexName, String indexTypeName, ExprNode[] parameters, ExprValidationContext validationContext) throws ExprValidationException {
        AdvancedIndexFactoryProviderQuadTree.validateParameters(indexTypeName, parameters);
        try {
            return AdvancedIndexFactoryProviderQuadTree.configureQuadTree(indexName, ExprNodeUtility.getEvaluators(parameters), validationContext.getExprEvaluatorContext());
        }
        catch (EPException ex) {
            throw new ExprValidationException(ex.getMessage(), ex);
        }
    }

    protected static void validateParameters(String indexTypeName, ExprNode[] parameters) throws ExprValidationException {
        AdvancedIndexValidationHelper.validateParameterCount(4, 6, indexTypeName, parameters == null ? 0 : parameters.length);
        AdvancedIndexValidationHelper.validateParameterReturnTypeNumber(indexTypeName, 0, parameters[0], "xMin");
        AdvancedIndexValidationHelper.validateParameterReturnTypeNumber(indexTypeName, 1, parameters[1], "yMin");
        AdvancedIndexValidationHelper.validateParameterReturnTypeNumber(indexTypeName, 2, parameters[2], "width");
        AdvancedIndexValidationHelper.validateParameterReturnTypeNumber(indexTypeName, 3, parameters[3], "height");
        if (parameters.length > 4) {
            AdvancedIndexValidationHelper.validateParameterReturnType(Integer.class, indexTypeName, 4, parameters[4], "leafCapacity");
        }
        if (parameters.length > 5) {
            AdvancedIndexValidationHelper.validateParameterReturnType(Integer.class, indexTypeName, 5, parameters[5], "maxTreeHeight");
        }
    }

    protected static AdvancedIndexConfigContextPartition configureQuadTree(String indexName, ExprEvaluator[] parameters, ExprEvaluatorContext exprEvaluatorContext) {
        int maxTreeHeight;
        int leafCapacity;
        double x = AdvancedIndexEvaluationHelper.evalDoubleParameter(parameters[0], indexName, "xMin", exprEvaluatorContext);
        double y = AdvancedIndexEvaluationHelper.evalDoubleParameter(parameters[1], indexName, "yMin", exprEvaluatorContext);
        double width = AdvancedIndexEvaluationHelper.evalDoubleParameter(parameters[2], indexName, "width", exprEvaluatorContext);
        if (width <= 0.0) {
            throw AdvancedIndexEvaluationHelper.invalidParameterValue(indexName, "width", width, "value>0");
        }
        double height = AdvancedIndexEvaluationHelper.evalDoubleParameter(parameters[3], indexName, "height", exprEvaluatorContext);
        if (height <= 0.0) {
            throw AdvancedIndexEvaluationHelper.invalidParameterValue(indexName, "height", height, "value>0");
        }
        int n = leafCapacity = parameters.length > 4 ? AdvancedIndexEvaluationHelper.evalIntParameter(parameters[4], indexName, "leafCapacity", exprEvaluatorContext) : 4;
        if (leafCapacity < 1) {
            throw AdvancedIndexEvaluationHelper.invalidParameterValue(indexName, "leafCapacity", leafCapacity, "value>=1");
        }
        int n2 = maxTreeHeight = parameters.length > 5 ? AdvancedIndexEvaluationHelper.evalIntParameter(parameters[5], indexName, "maxTreeHeight", exprEvaluatorContext) : 20;
        if (maxTreeHeight < 2) {
            throw AdvancedIndexEvaluationHelper.invalidParameterValue(indexName, "maxTreeHeight", maxTreeHeight, "value>=2");
        }
        return new AdvancedIndexConfigContextPartitionQuadTree(x, y, width, height, leafCapacity, maxTreeHeight);
    }
}

