/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.index.quadtree;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.index.quadtree.EngineImportApplicationDotMethodBase;
import com.espertech.esper.epl.util.EPLExpressionParamType;
import com.espertech.esper.epl.util.EPLValidationUtil;
import com.espertech.esper.spatial.quadtree.core.BoundingBox;

public class EngineImportApplicationDotMethodPointInsideRectange
extends EngineImportApplicationDotMethodBase {
    protected static final String LOOKUP_OPERATION_NAME = "point.inside(rectangle)";
    public static final String INDEXTYPE_NAME = "pointregionquadtree";

    public EngineImportApplicationDotMethodPointInsideRectange(String lhsName, ExprNode[] lhs, String dotMethodName, String rhsName, ExprNode[] rhs, ExprNode[] indexNamedParameter) {
        super(lhsName, lhs, dotMethodName, rhsName, rhs, indexNamedParameter);
    }

    @Override
    protected ExprEvaluator validateAll(String lhsName, ExprNode[] lhs, String rhsName, ExprNode[] rhs, ExprValidationContext validationContext) throws ExprValidationException {
        EPLValidationUtil.validateParameterNumber(lhsName, "left-hand-side", false, 2, lhs.length);
        EPLValidationUtil.validateParametersTypePredefined(lhs, lhsName, "left-hand-side", EPLExpressionParamType.NUMERIC);
        EPLValidationUtil.validateParameterNumber(rhsName, "right-hand-side", true, 4, rhs.length);
        EPLValidationUtil.validateParametersTypePredefined(rhs, rhsName, "right-hand-side", EPLExpressionParamType.NUMERIC);
        ExprEvaluator pxEval = lhs[0].getExprEvaluator();
        ExprEvaluator pyEval = lhs[1].getExprEvaluator();
        ExprEvaluator xEval = rhs[0].getExprEvaluator();
        ExprEvaluator yEval = rhs[1].getExprEvaluator();
        ExprEvaluator widthEval = rhs[2].getExprEvaluator();
        ExprEvaluator heightEval = rhs[3].getExprEvaluator();
        return new PointIntersectsRectangleEvaluator(pxEval, pyEval, xEval, yEval, widthEval, heightEval);
    }

    @Override
    protected String operationName() {
        return LOOKUP_OPERATION_NAME;
    }

    @Override
    protected String indexTypeName() {
        return INDEXTYPE_NAME;
    }

    public static final class PointIntersectsRectangleEvaluator
    implements ExprEvaluator {
        private final ExprEvaluator pxEval;
        private final ExprEvaluator pyEval;
        private final ExprEvaluator xEval;
        private final ExprEvaluator yEval;
        private final ExprEvaluator widthEval;
        private final ExprEvaluator heightEval;

        PointIntersectsRectangleEvaluator(ExprEvaluator pxEval, ExprEvaluator pyEval, ExprEvaluator xEval, ExprEvaluator yEval, ExprEvaluator widthEval, ExprEvaluator heightEval) {
            this.pxEval = pxEval;
            this.pyEval = pyEval;
            this.xEval = xEval;
            this.yEval = yEval;
            this.widthEval = widthEval;
            this.heightEval = heightEval;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Number px = (Number)this.pxEval.evaluate(eventsPerStream, isNewData, context);
            if (px == null) {
                return null;
            }
            Number py = (Number)this.pyEval.evaluate(eventsPerStream, isNewData, context);
            if (py == null) {
                return null;
            }
            Number x = (Number)this.xEval.evaluate(eventsPerStream, isNewData, context);
            if (x == null) {
                return null;
            }
            Number y = (Number)this.yEval.evaluate(eventsPerStream, isNewData, context);
            if (y == null) {
                return null;
            }
            Number width = (Number)this.widthEval.evaluate(eventsPerStream, isNewData, context);
            if (width == null) {
                return null;
            }
            Number height = (Number)this.heightEval.evaluate(eventsPerStream, isNewData, context);
            if (height == null) {
                return null;
            }
            return BoundingBox.containsPoint(x.doubleValue(), y.doubleValue(), width.doubleValue(), height.doubleValue(), px.doubleValue(), py.doubleValue());
        }

        @Override
        public Class getType() {
            return Boolean.class;
        }
    }
}

