/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.composite;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategy;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyGE;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyGT;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyLE;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyLT;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyRangeInverted;
import com.espertech.esper.epl.join.exec.composite.CompositeAccessStrategyRangeNormal;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQuery;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQueryResultPostProcessor;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeIn;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeRelOp;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class CompositeIndexQueryRange
implements CompositeIndexQuery {
    private final CompositeAccessStrategy strategy;
    private CompositeIndexQuery next;

    public CompositeIndexQueryRange(boolean isNWOnTrigger, int lookupStream, int numStreams, SubordPropRangeKey subqRangeKey, Class coercionType, List<String> expressionTexts) {
        QueryGraphValueEntryRange rangeProp = subqRangeKey.getRangeInfo();
        if (rangeProp.getType().isRange()) {
            QueryGraphValueEntryRangeIn rangeIn = (QueryGraphValueEntryRangeIn)rangeProp;
            ExprEvaluator start = rangeIn.getExprStart().getExprEvaluator();
            expressionTexts.add(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(rangeIn.getExprStart()));
            boolean includeStart = rangeProp.getType().isIncludeStart();
            ExprEvaluator end = rangeIn.getExprEnd().getExprEvaluator();
            expressionTexts.add(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(rangeIn.getExprEnd()));
            boolean includeEnd = rangeProp.getType().isIncludeEnd();
            this.strategy = !rangeProp.getType().isRangeInverted() ? new CompositeAccessStrategyRangeNormal(isNWOnTrigger, lookupStream, numStreams, start, includeStart, end, includeEnd, coercionType, ((QueryGraphValueEntryRangeIn)rangeProp).isAllowRangeReversal()) : new CompositeAccessStrategyRangeInverted(isNWOnTrigger, lookupStream, numStreams, start, includeStart, end, includeEnd, coercionType);
        } else {
            QueryGraphValueEntryRangeRelOp relOp = (QueryGraphValueEntryRangeRelOp)rangeProp;
            ExprEvaluator key = relOp.getExpression().getExprEvaluator();
            expressionTexts.add(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(relOp.getExpression()));
            if (rangeProp.getType() == QueryGraphRangeEnum.GREATER_OR_EQUAL) {
                this.strategy = new CompositeAccessStrategyGE(isNWOnTrigger, lookupStream, numStreams, key, coercionType);
            } else if (rangeProp.getType() == QueryGraphRangeEnum.GREATER) {
                this.strategy = new CompositeAccessStrategyGT(isNWOnTrigger, lookupStream, numStreams, key, coercionType);
            } else if (rangeProp.getType() == QueryGraphRangeEnum.LESS_OR_EQUAL) {
                this.strategy = new CompositeAccessStrategyLE(isNWOnTrigger, lookupStream, numStreams, key, coercionType);
            } else if (rangeProp.getType() == QueryGraphRangeEnum.LESS) {
                this.strategy = new CompositeAccessStrategyLT(isNWOnTrigger, lookupStream, numStreams, key, coercionType);
            } else {
                throw new IllegalArgumentException("Comparison operator " + (Object)((Object)rangeProp.getType()) + " not supported");
            }
        }
    }

    @Override
    public void add(EventBean theEvent, Map parent, Set<EventBean> result, CompositeIndexQueryResultPostProcessor postProcessor) {
        this.strategy.lookup(theEvent, parent, result, this.next, null, null, postProcessor);
    }

    @Override
    public void add(EventBean[] eventsPerStream, Map parent, Collection<EventBean> result, CompositeIndexQueryResultPostProcessor postProcessor) {
        this.strategy.lookup(eventsPerStream, parent, result, this.next, null, null, postProcessor);
    }

    @Override
    public Set<EventBean> get(EventBean theEvent, Map parent, ExprEvaluatorContext context, CompositeIndexQueryResultPostProcessor postProcessor) {
        return this.strategy.lookup(theEvent, parent, null, this.next, context, null, postProcessor);
    }

    @Override
    public Collection<EventBean> get(EventBean[] eventsPerStream, Map parent, ExprEvaluatorContext context, CompositeIndexQueryResultPostProcessor postProcessor) {
        return this.strategy.lookup(eventsPerStream, parent, null, this.next, context, null, postProcessor);
    }

    @Override
    public Set<EventBean> getCollectKeys(EventBean theEvent, Map parent, ExprEvaluatorContext context, ArrayList<Object> keys, CompositeIndexQueryResultPostProcessor postProcessor) {
        return this.strategy.lookup(theEvent, parent, null, this.next, context, keys, postProcessor);
    }

    @Override
    public Collection<EventBean> getCollectKeys(EventBean[] eventsPerStream, Map parent, ExprEvaluatorContext context, ArrayList<Object> keys, CompositeIndexQueryResultPostProcessor postProcessor) {
        return this.strategy.lookup(eventsPerStream, parent, null, this.next, context, keys, postProcessor);
    }

    protected static Set<EventBean> handle(EventBean theEvent, SortedMap sortedMapOne, SortedMap sortedMapTwo, Set<EventBean> result, CompositeIndexQuery next, CompositeIndexQueryResultPostProcessor postProcessor) {
        if (next == null) {
            if (result == null) {
                result = new HashSet<EventBean>();
            }
            CompositeIndexQueryRange.addResults(sortedMapOne, sortedMapTwo, result, postProcessor);
            return result;
        }
        if (result == null) {
            result = new HashSet<EventBean>();
        }
        SortedMap map = sortedMapOne;
        for (Map.Entry entry : map.entrySet()) {
            next.add(theEvent, (Map)entry.getValue(), result, postProcessor);
        }
        if (sortedMapTwo != null) {
            map = sortedMapTwo;
            for (Map.Entry entry : map.entrySet()) {
                next.add(theEvent, (Map)entry.getValue(), result, postProcessor);
            }
        }
        return result;
    }

    protected static Collection<EventBean> handle(EventBean[] eventsPerStream, SortedMap sortedMapOne, SortedMap sortedMapTwo, Collection<EventBean> result, CompositeIndexQuery next, CompositeIndexQueryResultPostProcessor postProcessor) {
        if (next == null) {
            if (result == null) {
                result = new HashSet<EventBean>();
            }
            CompositeIndexQueryRange.addResults(sortedMapOne, sortedMapTwo, result, postProcessor);
            return result;
        }
        if (result == null) {
            result = new HashSet<EventBean>();
        }
        SortedMap map = sortedMapOne;
        for (Map.Entry entry : map.entrySet()) {
            next.add(eventsPerStream, (Map)entry.getValue(), result, postProcessor);
        }
        if (sortedMapTwo != null) {
            map = sortedMapTwo;
            for (Map.Entry entry : map.entrySet()) {
                next.add(eventsPerStream, (Map)entry.getValue(), result, postProcessor);
            }
        }
        return result;
    }

    private static void addResults(SortedMap sortedMapOne, SortedMap sortedMapTwo, Collection<EventBean> result, CompositeIndexQueryResultPostProcessor postProcessor) {
        CompositeIndexQueryRange.addResults(sortedMapOne, result, postProcessor);
        if (sortedMapTwo != null) {
            CompositeIndexQueryRange.addResults(sortedMapTwo, result, postProcessor);
        }
    }

    private static void addResults(SortedMap sortedMapOne, Collection<EventBean> result, CompositeIndexQueryResultPostProcessor postProcessor) {
        SortedMap map = sortedMapOne;
        if (postProcessor != null) {
            for (Map.Entry entry : map.entrySet()) {
                postProcessor.add(entry.getValue(), result);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                result.addAll((Collection)entry.getValue());
            }
        }
    }

    @Override
    public void setNext(CompositeIndexQuery next) {
        this.next = next;
    }
}

