/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.event.EventBeanUtility;
import java.util.Arrays;
import java.util.Set;

public abstract class PropertyIndexedEventTable
implements EventTable {
    protected final EventPropertyGetter[] propertyGetters;
    protected final EventTableOrganization organization;

    public abstract Set<EventBean> lookup(Object[] var1);

    public PropertyIndexedEventTable(EventPropertyGetter[] propertyGetters, EventTableOrganization organization) {
        this.propertyGetters = propertyGetters;
        this.organization = organization;
    }

    protected MultiKeyUntyped getMultiKey(EventBean theEvent) {
        return EventBeanUtility.getMultiKey(theEvent, this.propertyGetters);
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext exprEvaluatorContext) {
        if (newData != null) {
            for (EventBean theEvent : newData) {
                this.add(theEvent, exprEvaluatorContext);
            }
        }
        if (oldData != null) {
            for (EventBean theEvent : oldData) {
                this.remove(theEvent, exprEvaluatorContext);
            }
        }
    }

    @Override
    public void add(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        if (events != null) {
            for (EventBean theEvent : events) {
                this.add(theEvent, exprEvaluatorContext);
            }
        }
    }

    @Override
    public void remove(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        if (events != null) {
            for (EventBean theEvent : events) {
                this.remove(theEvent, exprEvaluatorContext);
            }
        }
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.organization.getStreamNum() + " propertyGetters=" + Arrays.toString(this.propertyGetters);
    }

    @Override
    public EventTableOrganization getOrganization() {
        return this.organization;
    }
}

