/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.EventTableFactoryTableIdent;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.EventTableOrganizationType;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleUnadorned;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleUnique;
import com.espertech.esper.event.EventBeanUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyIndexedEventTableSingleFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String propertyName;
    protected final boolean unique;
    protected final String optionalIndexName;
    protected final EventPropertyGetter propertyGetter;
    private static Logger log = LoggerFactory.getLogger(PropertyIndexedEventTableSingleFactory.class);

    public PropertyIndexedEventTableSingleFactory(int streamNum, EventType eventType, String propertyName, boolean unique, String optionalIndexName) {
        this.streamNum = streamNum;
        this.propertyName = propertyName;
        this.unique = unique;
        this.optionalIndexName = optionalIndexName;
        this.propertyGetter = EventBeanUtility.getAssertPropertyGetter(eventType, propertyName);
    }

    @Override
    public EventTable[] makeEventTables(EventTableFactoryTableIdent tableIdent, ExprEvaluatorContext exprEvaluatorContext) {
        EventTableOrganization organization = new EventTableOrganization(this.optionalIndexName, this.unique, false, this.streamNum, new String[]{this.propertyName}, EventTableOrganizationType.HASH);
        if (this.unique) {
            return new EventTable[]{new PropertyIndexedEventTableSingleUnique(this.propertyGetter, organization)};
        }
        return new EventTable[]{new PropertyIndexedEventTableSingleUnadorned(this.propertyGetter, organization)};
    }

    @Override
    public Class getEventTableClass() {
        if (this.unique) {
            return PropertyIndexedEventTableSingleUnique.class;
        }
        return PropertyIndexedEventTableSingle.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + (this.unique ? " unique" : " non-unique") + " streamNum=" + this.streamNum + " propertyName=" + this.propertyName;
    }
}

