/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.table.EventTableAsSet;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableUnique;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PropertyIndexedEventTableSingleUnique
extends PropertyIndexedEventTableSingle
implements EventTableAsSet {
    private final Map<Object, EventBean> propertyIndex;
    private final boolean canClear;

    public PropertyIndexedEventTableSingleUnique(EventPropertyGetter propertyGetter, EventTableOrganization organization) {
        super(propertyGetter, organization);
        this.propertyIndex = new HashMap<Object, EventBean>();
        this.canClear = true;
    }

    public PropertyIndexedEventTableSingleUnique(EventPropertyGetter propertyGetter, EventTableOrganization organization, Map<Object, EventBean> propertyIndex) {
        super(propertyGetter, organization);
        this.propertyIndex = propertyIndex;
        this.canClear = false;
    }

    @Override
    public Set<EventBean> lookup(Object key) {
        EventBean event = this.propertyIndex.get(key);
        if (event != null) {
            return Collections.singleton(event);
        }
        return null;
    }

    @Override
    public int getNumKeys() {
        return this.propertyIndex.size();
    }

    @Override
    public Object getIndex() {
        return this.propertyIndex;
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext exprEvaluatorContext) {
        if (oldData != null) {
            for (EventBean theEvent : oldData) {
                this.remove(theEvent, exprEvaluatorContext);
            }
        }
        if (newData != null) {
            for (EventBean theEvent : newData) {
                this.add(theEvent, exprEvaluatorContext);
            }
        }
    }

    @Override
    public void add(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        Object key = this.getKey(theEvent);
        EventBean existing = this.propertyIndex.put(key, theEvent);
        if (existing != null && !existing.equals(theEvent)) {
            throw PropertyIndexedEventTableUnique.handleUniqueIndexViolation(this.organization.getIndexName(), key);
        }
    }

    @Override
    public void remove(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        Object key = this.getKey(theEvent);
        this.propertyIndex.remove(key);
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.propertyIndex.values().iterator();
    }

    @Override
    public void clear() {
        if (this.canClear) {
            this.propertyIndex.clear();
        }
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public String toString() {
        return this.toQueryPlan();
    }

    @Override
    public Integer getNumberOfEvents() {
        return this.propertyIndex.size();
    }

    @Override
    public Set<EventBean> allValues() {
        if (this.propertyIndex.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<EventBean>(this.propertyIndex.values());
    }

    @Override
    public Class getProviderClass() {
        return PropertyIndexedEventTableSingleUnique.class;
    }
}

