/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.LookupStrategyType;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import java.util.ArrayDeque;
import java.util.Collection;

public class SubordFullTableScanLookupStrategyLocking
implements SubordTableLookupStrategy {
    private final Iterable<EventBean> contents;
    private final StatementAgentInstanceLock statementLock;

    public SubordFullTableScanLookupStrategyLocking(Iterable<EventBean> contents, StatementAgentInstanceLock statementLock) {
        this.contents = contents;
        this.statementLock = statementLock;
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] events, ExprEvaluatorContext context) {
        return this.lookupInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<EventBean> lookupInternal() {
        this.statementLock.acquireReadLock();
        try {
            ArrayDeque<EventBean> result = new ArrayDeque<EventBean>();
            for (EventBean eventBean : this.contents) {
                result.add(eventBean);
            }
            ArrayDeque<EventBean> arrayDeque = result;
            return arrayDeque;
        }
        finally {
            this.statementLock.releaseReadLock();
        }
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return new LookupStrategyDesc(LookupStrategyType.FULLTABLESCAN, null);
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName();
    }
}

