/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.plan.InKeywordTableLookupUtil;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import java.util.Collection;

public class SubordInKeywordMultiTableLookupStrategy
implements SubordTableLookupStrategy {
    protected final PropertyIndexedEventTableSingle[] indexes;
    protected final ExprEvaluator evaluator;
    private final LookupStrategyDesc strategyDesc;
    private EventBean[] events;

    public SubordInKeywordMultiTableLookupStrategy(int numStreamsOuter, ExprEvaluator evaluator, EventTable[] tables, LookupStrategyDesc strategyDesc) {
        this.evaluator = evaluator;
        this.strategyDesc = strategyDesc;
        this.events = new EventBean[numStreamsOuter + 1];
        this.indexes = new PropertyIndexedEventTableSingle[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            this.indexes[i] = (PropertyIndexedEventTableSingle)tables[i];
        }
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        System.arraycopy(eventsPerStream, 0, this.events, 1, eventsPerStream.length);
        return InKeywordTableLookupUtil.multiIndexLookup(this.evaluator, this.events, context, this.indexes);
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return this.strategyDesc;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName();
    }
}

