/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.hook.ExceptionHandlerExceptionType;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.ExceptionHandlingService;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.named.NamedWindowConsumerLatch;
import com.espertech.esper.epl.named.NamedWindowConsumerLatchFactory;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDeltaData;
import com.espertech.esper.epl.named.NamedWindowDispatchService;
import com.espertech.esper.epl.named.NamedWindowMgmtService;
import com.espertech.esper.epl.named.NamedWindowMgmtServiceImpl;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowTailView;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.timer.TimeSourceService;
import com.espertech.esper.util.ManagedReadWriteLock;
import com.espertech.esper.util.MetricUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NamedWindowDispatchServiceImpl
implements NamedWindowDispatchService {
    private final SchedulingService schedulingService;
    private final VariableService variableService;
    private final TableService tableService;
    private final ExceptionHandlingService exceptionHandlingService;
    private final boolean isPrioritized;
    private final ManagedReadWriteLock eventProcessingRWLock;
    private final MetricReportingService metricReportingService;
    private ThreadLocal<List<NamedWindowConsumerLatch>> threadLocal = new ThreadLocal<List<NamedWindowConsumerLatch>>(){

        @Override
        protected synchronized List<NamedWindowConsumerLatch> initialValue() {
            return new ArrayList<NamedWindowConsumerLatch>();
        }
    };
    private ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>> dispatchesPerStmtTL = new ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>>(){

        @Override
        protected synchronized Map<EPStatementAgentInstanceHandle, Object> initialValue() {
            return new HashMap<EPStatementAgentInstanceHandle, Object>();
        }
    };

    public NamedWindowDispatchServiceImpl(SchedulingService schedulingService, VariableService variableService, TableService tableService, boolean isPrioritized, ManagedReadWriteLock eventProcessingRWLock, ExceptionHandlingService exceptionHandlingService, MetricReportingService metricReportingService) {
        this.schedulingService = schedulingService;
        this.variableService = variableService;
        this.tableService = tableService;
        this.isPrioritized = isPrioritized;
        this.eventProcessingRWLock = eventProcessingRWLock;
        this.exceptionHandlingService = exceptionHandlingService;
        this.metricReportingService = metricReportingService;
    }

    @Override
    public NamedWindowProcessor createProcessor(String name, NamedWindowMgmtServiceImpl namedWindowMgmtService, NamedWindowDispatchService namedWindowDispatchService, String contextName, EventType eventType, StatementResultService statementResultService, ValueAddEventProcessor revisionProcessor, String eplExpression, String statementName, boolean isPrioritized, boolean isEnableSubqueryIndexShare, boolean enableQueryPlanLog, MetricReportingService metricReportingService, boolean isBatchingDataWindow, boolean isVirtualDataWindow, Set<String> optionalUniqueKeyProps, String eventTypeAsName, StatementContext statementContextCreateWindow) {
        return new NamedWindowProcessor(name, namedWindowMgmtService, namedWindowDispatchService, contextName, eventType, statementResultService, revisionProcessor, eplExpression, statementName, isPrioritized, isEnableSubqueryIndexShare, enableQueryPlanLog, metricReportingService, isBatchingDataWindow, isVirtualDataWindow, optionalUniqueKeyProps, eventTypeAsName, statementContextCreateWindow);
    }

    @Override
    public NamedWindowTailView createTailView(EventType eventType, NamedWindowMgmtService namedWindowMgmtService, NamedWindowDispatchService namedWindowDispatchService, StatementResultService statementResultService, ValueAddEventProcessor revisionProcessor, boolean prioritized, boolean parentBatchWindow, String contextName, TimeSourceService timeSourceService, ConfigurationEngineDefaults.Threading threadingConfig) {
        return new NamedWindowTailView(eventType, namedWindowMgmtService, namedWindowDispatchService, statementResultService, revisionProcessor, this.isPrioritized, parentBatchWindow, timeSourceService, threadingConfig);
    }

    @Override
    public void destroy() {
        this.threadLocal.remove();
        this.dispatchesPerStmtTL.remove();
    }

    @Override
    public void addDispatch(NamedWindowConsumerLatchFactory latchFactory, NamedWindowDeltaData delta, Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumers) {
        NamedWindowConsumerLatch latch = latchFactory.newLatch(delta, consumers);
        this.threadLocal.get().add(latch);
    }

    @Override
    public boolean dispatch() {
        List<NamedWindowConsumerLatch> dispatches = this.threadLocal.get();
        if (dispatches.isEmpty()) {
            return false;
        }
        while (!dispatches.isEmpty()) {
            this.eventProcessingRWLock.acquireReadLock();
            try {
                NamedWindowConsumerLatch[] units = dispatches.toArray(new NamedWindowConsumerLatch[dispatches.size()]);
                dispatches.clear();
                this.processDispatches(units);
            }
            catch (RuntimeException ex) {
                throw new EPException(ex);
            }
            finally {
                this.eventProcessingRWLock.releaseReadLock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDispatches(NamedWindowConsumerLatch[] dispatches) {
        Map<EPStatementAgentInstanceHandle, Object> dispatchesPerStmt;
        block30: {
            if (dispatches.length == 1) {
                block29: {
                    NamedWindowConsumerLatch latch = dispatches[0];
                    try {
                        latch.await();
                        EventBean[] newData = latch.getDeltaData().getNewData();
                        EventBean[] eventBeanArray = latch.getDeltaData().getOldData();
                        if (MetricReportingPath.isMetricsEnabled) {
                            for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : latch.getDispatchTo().entrySet()) {
                                EPStatementAgentInstanceHandle handle = entry.getKey();
                                if (handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                                    long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                                    long wallTimeBefore = MetricUtil.getWall();
                                    this.processHandle(handle, entry.getValue(), newData, eventBeanArray);
                                    long wallTimeAfter = MetricUtil.getWall();
                                    long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                                    long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                                    long deltaWall = wallTimeAfter - wallTimeBefore;
                                    this.metricReportingService.accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, 1);
                                } else {
                                    this.processHandle(handle, entry.getValue(), newData, eventBeanArray);
                                }
                                if (!this.isPrioritized || !handle.isPreemptive()) continue;
                                break block29;
                            }
                            break block29;
                        }
                        for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : latch.getDispatchTo().entrySet()) {
                            EPStatementAgentInstanceHandle handle = entry.getKey();
                            this.processHandle(handle, entry.getValue(), newData, eventBeanArray);
                            if (!this.isPrioritized || !handle.isPreemptive()) continue;
                            break;
                        }
                    }
                    finally {
                        latch.done();
                    }
                }
                return;
            }
            dispatchesPerStmt = this.dispatchesPerStmtTL.get();
            for (NamedWindowConsumerLatch namedWindowConsumerLatch : dispatches) {
                namedWindowConsumerLatch.await();
                for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : namedWindowConsumerLatch.getDispatchTo().entrySet()) {
                    EPStatementAgentInstanceHandle handle = entry.getKey();
                    Object perStmtObj = dispatchesPerStmt.get(handle);
                    if (perStmtObj == null) {
                        dispatchesPerStmt.put(handle, namedWindowConsumerLatch);
                        continue;
                    }
                    if (perStmtObj instanceof List) {
                        List list = (List)perStmtObj;
                        list.add(namedWindowConsumerLatch);
                        continue;
                    }
                    NamedWindowConsumerLatch unitObj = (NamedWindowConsumerLatch)perStmtObj;
                    ArrayList<NamedWindowConsumerLatch> list = new ArrayList<NamedWindowConsumerLatch>();
                    list.add(unitObj);
                    list.add(namedWindowConsumerLatch);
                    dispatchesPerStmt.put(handle, list);
                }
            }
            try {
                LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData> deltaPerConsumer;
                EventBean[] oldData;
                NamedWindowConsumerLatch unit;
                if (MetricReportingPath.isMetricsEnabled) {
                    for (Map.Entry entry : dispatchesPerStmt.entrySet()) {
                        EPStatementAgentInstanceHandle handle = (EPStatementAgentInstanceHandle)entry.getKey();
                        Object v = entry.getValue();
                        if (v instanceof NamedWindowConsumerLatch) {
                            unit = (NamedWindowConsumerLatch)v;
                            EventBean[] newData = unit.getDeltaData().getNewData();
                            oldData = unit.getDeltaData().getOldData();
                            if (handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                                long wallTimeBefore = MetricUtil.getWall();
                                this.processHandle(handle, unit.getDispatchTo().get(handle), newData, oldData);
                                long wallTimeAfter = MetricUtil.getWall();
                                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                                long deltaWall = wallTimeAfter - wallTimeBefore;
                                this.metricReportingService.accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, 1);
                            } else {
                                Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entries = unit.getDispatchTo();
                                List<NamedWindowConsumerView> items = entries.get(handle);
                                if (items != null) {
                                    this.processHandle(handle, items, newData, oldData);
                                }
                            }
                            if (!this.isPrioritized || !handle.isPreemptive()) continue;
                        } else {
                            deltaPerConsumer = this.getDeltaPerConsumer(v, handle);
                            if (handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                                long wallTimeBefore = MetricUtil.getWall();
                                this.processHandleMultiple(handle, deltaPerConsumer);
                                long wallTimeAfter = MetricUtil.getWall();
                                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                                long deltaWall = wallTimeAfter - wallTimeBefore;
                                this.metricReportingService.accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, 1);
                            } else {
                                this.processHandleMultiple(handle, deltaPerConsumer);
                            }
                            if (!this.isPrioritized || !handle.isPreemptive()) continue;
                        }
                        break block30;
                    }
                    break block30;
                }
                for (Map.Entry entry : dispatchesPerStmt.entrySet()) {
                    EPStatementAgentInstanceHandle handle = (EPStatementAgentInstanceHandle)entry.getKey();
                    Object v = entry.getValue();
                    if (v instanceof NamedWindowConsumerLatch) {
                        unit = (NamedWindowConsumerLatch)v;
                        EventBean[] newData = unit.getDeltaData().getNewData();
                        oldData = unit.getDeltaData().getOldData();
                        this.processHandle(handle, unit.getDispatchTo().get(handle), newData, oldData);
                        if (!this.isPrioritized || !handle.isPreemptive()) continue;
                    } else {
                        deltaPerConsumer = this.getDeltaPerConsumer(v, handle);
                        this.processHandleMultiple(handle, deltaPerConsumer);
                        if (!this.isPrioritized || !handle.isPreemptive()) continue;
                    }
                    break;
                }
            }
            finally {
                for (NamedWindowConsumerLatch namedWindowConsumerLatch : dispatches) {
                    namedWindowConsumerLatch.done();
                }
            }
        }
        dispatchesPerStmt.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHandleMultiple(EPStatementAgentInstanceHandle handle, Map<NamedWindowConsumerView, NamedWindowDeltaData> deltaPerConsumer) {
        handle.getStatementAgentInstanceLock().acquireWriteLock();
        try {
            if (handle.isHasVariables()) {
                this.variableService.setLocalVersion();
            }
            for (Map.Entry<NamedWindowConsumerView, NamedWindowDeltaData> entryDelta : deltaPerConsumer.entrySet()) {
                EventBean[] newData = entryDelta.getValue().getNewData();
                EventBean[] oldData = entryDelta.getValue().getOldData();
                entryDelta.getKey().update(newData, oldData);
            }
            handle.internalDispatch();
        }
        catch (RuntimeException ex) {
            this.exceptionHandlingService.handleException(ex, handle, ExceptionHandlerExceptionType.PROCESS, null);
        }
        finally {
            if (handle.isHasTableAccess()) {
                this.tableService.getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            handle.getStatementAgentInstanceLock().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHandle(EPStatementAgentInstanceHandle handle, List<NamedWindowConsumerView> value, EventBean[] newData, EventBean[] oldData) {
        handle.getStatementAgentInstanceLock().acquireWriteLock();
        try {
            if (handle.isHasVariables()) {
                this.variableService.setLocalVersion();
            }
            for (NamedWindowConsumerView consumerView : value) {
                consumerView.update(newData, oldData);
            }
            handle.internalDispatch();
        }
        catch (RuntimeException ex) {
            this.exceptionHandlingService.handleException(ex, handle, ExceptionHandlerExceptionType.PROCESS, null);
        }
        finally {
            if (handle.isHasTableAccess()) {
                this.tableService.getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            handle.getStatementAgentInstanceLock().releaseWriteLock();
        }
    }

    public LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData> getDeltaPerConsumer(Object perStmtObj, EPStatementAgentInstanceHandle handle) {
        List list = (List)perStmtObj;
        LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData> deltaPerConsumer = new LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData>();
        for (NamedWindowConsumerLatch unit : list) {
            for (NamedWindowConsumerView consumerView : unit.getDispatchTo().get(handle)) {
                NamedWindowDeltaData deltaForConsumer = deltaPerConsumer.get(consumerView);
                if (deltaForConsumer == null) {
                    deltaPerConsumer.put(consumerView, unit.getDeltaData());
                    continue;
                }
                NamedWindowDeltaData aggregated = new NamedWindowDeltaData(deltaForConsumer, unit.getDeltaData());
                deltaPerConsumer.put(consumerView, aggregated);
            }
        }
        return deltaPerConsumer;
    }
}

