/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.spec.AnnotationDesc;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class ASTAnnotationHelper {
    public static AnnotationDesc walk(EsperEPL2GrammarParser.AnnotationEnumContext ctx, EngineImportService engineImportService) throws ASTWalkException {
        String name = ASTUtil.unescapeClassIdent(ctx.classIdentifier());
        ArrayList<Pair<String, Object>> values = new ArrayList<Pair<String, Object>>();
        if (ctx.elementValueEnum() != null) {
            Object value = ASTAnnotationHelper.walkValue(ctx.elementValueEnum(), engineImportService);
            values.add(new Pair<String, Object>("value", value));
        } else if (ctx.elementValuePairsEnum() != null) {
            ASTAnnotationHelper.walkValuePairs(ctx.elementValuePairsEnum(), values, engineImportService);
        }
        return new AnnotationDesc(name, values);
    }

    private static void walkValuePairs(EsperEPL2GrammarParser.ElementValuePairsEnumContext elementValuePairsEnumContext, List<Pair<String, Object>> values, EngineImportService engineImportService) {
        for (EsperEPL2GrammarParser.ElementValuePairEnumContext ctx : elementValuePairsEnumContext.elementValuePairEnum()) {
            Pair<String, Object> pair = ASTAnnotationHelper.walkValuePair(ctx, engineImportService);
            values.add(pair);
        }
    }

    private static Object walkValue(EsperEPL2GrammarParser.ElementValueEnumContext ctx, EngineImportService engineImportService) {
        if (ctx.elementValueArrayEnum() != null) {
            return ASTAnnotationHelper.walkArray(ctx.elementValueArrayEnum(), engineImportService);
        }
        if (ctx.annotationEnum() != null) {
            return ASTAnnotationHelper.walk(ctx.annotationEnum(), engineImportService);
        }
        if (ctx.v != null) {
            return ctx.v.getText();
        }
        if (ctx.classIdentifier() != null) {
            return ASTAnnotationHelper.walkClassIdent(ctx.classIdentifier(), engineImportService);
        }
        return ASTConstantHelper.parse((ParseTree)ctx.constant());
    }

    private static Pair<String, Object> walkValuePair(EsperEPL2GrammarParser.ElementValuePairEnumContext ctx, EngineImportService engineImportService) {
        String name = ctx.keywordAllowedIdent().getText();
        Object value = ASTAnnotationHelper.walkValue(ctx.elementValueEnum(), engineImportService);
        return new Pair<String, Object>(name, value);
    }

    private static Object walkClassIdent(EsperEPL2GrammarParser.ClassIdentifierContext ctx, EngineImportService engineImportService) {
        Object enumValue;
        String enumValueText = ctx.getText();
        try {
            enumValue = JavaClassHelper.resolveIdentAsEnumConst(enumValueText, engineImportService, true);
        }
        catch (ExprValidationException e) {
            throw ASTWalkException.from("Annotation value '" + enumValueText + "' is not recognized as an enumeration value, please check imports or use a primitive or string type");
        }
        if (enumValue != null) {
            return enumValue;
        }
        throw ASTWalkException.from("Annotation enumeration value '" + enumValueText + "' not recognized as an enumeration class, please check imports or type used");
    }

    private static Object[] walkArray(EsperEPL2GrammarParser.ElementValueArrayEnumContext ctx, EngineImportService engineImportService) {
        List<EsperEPL2GrammarParser.ElementValueEnumContext> elements = ctx.elementValueEnum();
        Object[] values = new Object[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            values[i] = ASTAnnotationHelper.walkValue(elements.get(i), engineImportService);
        }
        return values;
    }
}

