/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTAnnotationHelper;
import com.espertech.esper.epl.parse.ASTCreateSchemaHelper;
import com.espertech.esper.epl.parse.ASTExprHelper;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.spec.AnnotationDesc;
import com.espertech.esper.epl.spec.CreateTableColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.tree.Tree;

public class ASTTableHelper {
    public static List<CreateTableColumn> getColumns(List<EsperEPL2GrammarParser.CreateTableColumnContext> ctxs, Map<Tree, ExprNode> astExprNodeMap, EngineImportService engineImportService) {
        ArrayList<CreateTableColumn> cols = new ArrayList<CreateTableColumn>(ctxs.size());
        for (EsperEPL2GrammarParser.CreateTableColumnContext colctx : ctxs) {
            cols.add(ASTTableHelper.getColumn(colctx, astExprNodeMap, engineImportService));
        }
        return cols;
    }

    private static CreateTableColumn getColumn(EsperEPL2GrammarParser.CreateTableColumnContext ctx, Map<Tree, ExprNode> astExprNodeMap, EngineImportService engineImportService) {
        String columnName = ctx.n.getText();
        ExprNode optExpression = null;
        if (ctx.builtinFunc() != null || ctx.libFunction() != null) {
            optExpression = ASTExprHelper.exprCollectSubNodes((Tree)ctx, 0, astExprNodeMap).get(0);
        }
        String optTypeName = null;
        Boolean optTypeIsArray = null;
        Boolean optTypeIsPrimitiveArray = null;
        if (ctx.createTableColumnPlain() != null) {
            EsperEPL2GrammarParser.CreateTableColumnPlainContext sub = ctx.createTableColumnPlain();
            optTypeName = ASTUtil.unescapeClassIdent(sub.classIdentifier());
            optTypeIsArray = sub.b != null;
            optTypeIsPrimitiveArray = ASTCreateSchemaHelper.validateIsPrimitiveArray(sub.p);
        }
        Boolean primaryKey = false;
        if (ctx.p != null) {
            if (!ctx.p.getText().toLowerCase(Locale.ENGLISH).equals("primary")) {
                throw ASTWalkException.from("Invalid keyword '" + ctx.p.getText() + "' encountered, expected 'primary key'");
            }
            if (!ctx.k.getText().toLowerCase(Locale.ENGLISH).equals("key")) {
                throw ASTWalkException.from("Invalid keyword '" + ctx.k.getText() + "' encountered, expected 'primary key'");
            }
            primaryKey = true;
        }
        List<AnnotationDesc> annots = Collections.emptyList();
        if (ctx.annotationEnum() != null) {
            annots = new ArrayList(ctx.annotationEnum().size());
            for (EsperEPL2GrammarParser.AnnotationEnumContext anctx : ctx.annotationEnum()) {
                annots.add(ASTAnnotationHelper.walk(anctx, engineImportService));
            }
        }
        if (ctx.typeExpressionAnnotation() != null) {
            if (annots.isEmpty()) {
                annots = new ArrayList();
            }
            for (EsperEPL2GrammarParser.TypeExpressionAnnotationContext anno : ctx.typeExpressionAnnotation()) {
                annots.add(new AnnotationDesc(anno.n.getText(), anno.v.getText()));
            }
        }
        return new CreateTableColumn(columnName, optExpression, optTypeName, optTypeIsArray, optTypeIsPrimitiveArray, annots, primaryKey);
    }
}

