/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.property;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.property.ContainedEventEval;
import com.espertech.esper.epl.property.PropertyEvaluator;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEvaluatorNested
implements PropertyEvaluator {
    private static final Logger log = LoggerFactory.getLogger(PropertyEvaluatorNested.class);
    private final ContainedEventEval[] containedEventEvals;
    private final FragmentEventType[] fragmentEventType;
    private final ExprEvaluator[] whereClauses;
    private final EventBean[] eventsPerStream;
    private final int lastLevel;
    private final List<String> expressionTexts;

    public PropertyEvaluatorNested(ContainedEventEval[] containedEventEvals, FragmentEventType[] fragmentEventType, ExprEvaluator[] whereClauses, List<String> expressionTexts) {
        this.fragmentEventType = fragmentEventType;
        this.containedEventEvals = containedEventEvals;
        this.whereClauses = whereClauses;
        this.lastLevel = fragmentEventType.length - 1;
        this.eventsPerStream = new EventBean[fragmentEventType.length + 1];
        this.expressionTexts = expressionTexts;
    }

    @Override
    public EventBean[] getProperty(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayDeque<EventBean> resultEvents = new ArrayDeque<EventBean>();
        this.eventsPerStream[0] = theEvent;
        this.populateEvents(theEvent, 0, resultEvents, exprEvaluatorContext);
        if (resultEvents.isEmpty()) {
            return null;
        }
        return resultEvents.toArray(new EventBean[resultEvents.size()]);
    }

    private void populateEvents(EventBean branch, int level, Collection<EventBean> events, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            Object result = this.containedEventEvals[level].getFragment(branch, this.eventsPerStream, exprEvaluatorContext);
            if (this.fragmentEventType[level].isIndexed()) {
                EventBean[] fragments = (EventBean[])result;
                if (level == this.lastLevel) {
                    if (this.whereClauses[level] != null) {
                        EventBean[] eventBeanArray = fragments;
                        int n = eventBeanArray.length;
                        for (int i = 0; i < n; ++i) {
                            EventBean theEvent;
                            this.eventsPerStream[level + 1] = theEvent = eventBeanArray[i];
                            if (!ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) continue;
                            events.add(theEvent);
                        }
                    } else {
                        events.addAll(Arrays.asList(fragments));
                    }
                } else if (this.whereClauses[level] != null) {
                    EventBean[] eventBeanArray = fragments;
                    int n = eventBeanArray.length;
                    for (int i = 0; i < n; ++i) {
                        EventBean next;
                        this.eventsPerStream[level + 1] = next = eventBeanArray[i];
                        if (!ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) continue;
                        this.populateEvents(next, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    EventBean[] eventBeanArray = fragments;
                    int n = eventBeanArray.length;
                    for (int i = 0; i < n; ++i) {
                        EventBean next;
                        this.eventsPerStream[level + 1] = next = eventBeanArray[i];
                        this.populateEvents(next, level + 1, events, exprEvaluatorContext);
                    }
                }
            } else {
                EventBean fragment = (EventBean)result;
                if (level == this.lastLevel) {
                    if (this.whereClauses[level] != null) {
                        this.eventsPerStream[level + 1] = fragment;
                        if (ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) {
                            events.add(fragment);
                        }
                    } else {
                        events.add(fragment);
                    }
                } else if (this.whereClauses[level] != null) {
                    this.eventsPerStream[level + 1] = fragment;
                    if (ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) {
                        this.populateEvents(fragment, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    this.eventsPerStream[level + 1] = fragment;
                    this.populateEvents(fragment, level + 1, events, exprEvaluatorContext);
                }
            }
        }
        catch (RuntimeException ex) {
            log.error("Unexpected error evaluating property expression for event of type '" + branch.getEventType().getName() + "' and property '" + this.expressionTexts.get(level + 1) + "': " + ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public EventType getFragmentEventType() {
        return this.fragmentEventType[this.lastLevel].getFragmentType();
    }

    @Override
    public boolean compareTo(PropertyEvaluator otherEval) {
        return false;
    }
}

