/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.mgmt;

import com.espertech.esper.client.ConfigurationPlugInAggregationMultiFunction;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.table.ExprTableIdentNode;
import com.espertech.esper.epl.expression.table.ExprTableIdentNodeSubpropAccessor;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.parse.ASTAggregationHelper;
import com.espertech.esper.epl.table.mgmt.TableExprEvaluatorContext;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumn;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.epl.table.mgmt.TableMetadataInternalEventToPublic;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.table.mgmt.TableServiceUtil;
import com.espertech.esper.epl.table.mgmt.TableStateFactory;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.table.mgmt.TableStateInstanceGrouped;
import com.espertech.esper.epl.table.mgmt.TableStateInstanceGroupedImpl;
import com.espertech.esper.epl.table.mgmt.TableStateInstanceUngrouped;
import com.espertech.esper.epl.table.mgmt.TableStateInstanceUngroupedImpl;
import com.espertech.esper.epl.table.mgmt.TableStateRowFactory;
import com.espertech.esper.epl.table.strategy.ExprTableEvalStrategyFactory;
import com.espertech.esper.epl.table.strategy.TableAndLockGrouped;
import com.espertech.esper.epl.table.strategy.TableAndLockProvider;
import com.espertech.esper.epl.table.strategy.TableAndLockProviderGroupedImpl;
import com.espertech.esper.epl.table.strategy.TableAndLockProviderUngroupedImpl;
import com.espertech.esper.epl.table.strategy.TableAndLockUngrouped;
import com.espertech.esper.epl.table.upd.TableUpdateStrategy;
import com.espertech.esper.epl.table.upd.TableUpdateStrategyFactory;
import com.espertech.esper.epl.table.upd.TableUpdateStrategyReceiver;
import com.espertech.esper.epl.updatehelper.EventBeanUpdateHelper;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.plugin.PlugInAggregationMultiFunctionFactory;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.LazyAllocatedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableServiceImpl
implements TableService {
    private static final Logger QUERY_PLAN_LOG = LoggerFactory.getLogger((String)"com.espertech.esper.queryplan");
    private final Map<String, TableMetadata> tables = new HashMap<String, TableMetadata>();
    private final TableExprEvaluatorContext tableExprEvaluatorContext = new TableExprEvaluatorContext();

    @Override
    public void validateAddIndex(String createIndexStatementName, TableMetadata tableMetadata, String explicitIndexName, QueryPlanIndexItem explicitIndexDesc, IndexMultiKey imk) throws ExprValidationException {
        tableMetadata.validateAddIndexAssignUpdateStrategies(createIndexStatementName, imk, explicitIndexName, explicitIndexDesc);
    }

    @Override
    public TableUpdateStrategy getTableUpdateStrategy(TableMetadata tableMetadata, EventBeanUpdateHelper updateHelper, boolean isOnMerge) throws ExprValidationException {
        return TableUpdateStrategyFactory.validateGetTableUpdateStrategy(tableMetadata, updateHelper, isOnMerge);
    }

    @Override
    public Collection<Integer> getAgentInstanceIds(String name) {
        TableMetadata metadata = this.tables.get(name);
        if (metadata == null) {
            throw new IllegalArgumentException("Failed to find table for name '" + name + "'");
        }
        return metadata.getAgentInstanceIds();
    }

    @Override
    public TableExprEvaluatorContext getTableExprEvaluatorContext() {
        return this.tableExprEvaluatorContext;
    }

    @Override
    public TableMetadata getTableMetadata(String tableName) {
        return this.tables.get(tableName);
    }

    @Override
    public TableMetadata addTable(String tableName, String eplExpression, String statementName, Class[] keyTypes, Map<String, TableMetadataColumn> tableColumns, TableStateRowFactory tableStateRowFactory, int numberMethodAggregations, StatementContext statementContext, ObjectArrayEventType internalEventType, ObjectArrayEventType publicEventType, TableMetadataInternalEventToPublic eventToPublic, boolean queryPlanLogging) throws ExprValidationException {
        final TableMetadata metadata = new TableMetadata(tableName, eplExpression, statementName, keyTypes, tableColumns, tableStateRowFactory, numberMethodAggregations, statementContext, internalEventType, publicEventType, eventToPublic, queryPlanLogging);
        TableStateFactory tableStateFactory = keyTypes.length == 0 ? new TableStateFactory(){

            @Override
            public TableStateInstance makeTableState(AgentInstanceContext agentInstanceContext) {
                return new TableStateInstanceUngroupedImpl(metadata, agentInstanceContext);
            }
        } : new TableStateFactory(){

            @Override
            public TableStateInstance makeTableState(AgentInstanceContext agentInstanceContext) {
                return new TableStateInstanceGroupedImpl(metadata, agentInstanceContext);
            }
        };
        metadata.setTableStateFactory(tableStateFactory);
        this.tables.put(tableName, metadata);
        return metadata;
    }

    @Override
    public void removeTableIfFound(String tableName) {
        TableMetadata metadata = this.tables.remove(tableName);
        if (metadata != null) {
            metadata.clearTableInstances();
        }
    }

    @Override
    public TableStateInstance getState(String name, int agentInstanceId) {
        return this.assertGetState(name, agentInstanceId);
    }

    private TableStateInstance assertGetState(String name, int agentInstanceId) {
        TableMetadata metadata = this.tables.get(name);
        if (metadata == null) {
            throw new IllegalArgumentException("Failed to find table for name '" + name + "'");
        }
        return metadata.getState(agentInstanceId);
    }

    public static Logger getQueryPlanLog() {
        return QUERY_PLAN_LOG;
    }

    @Override
    public TableMetadata getTableMetadataFromEventType(EventType type) {
        String tableName = TableServiceUtil.getTableNameFromEventType(type);
        if (tableName == null) {
            return null;
        }
        return this.tables.get(tableName);
    }

    @Override
    public Pair<ExprNode, List<ExprChainedSpec>> getTableNodeChainable(StreamTypeService streamTypeService, List<ExprChainedSpec> chainSpec, EngineImportService engineImportService) throws ExprValidationException {
        String unresolvedPropertyName = (chainSpec = new ArrayList<ExprChainedSpec>(chainSpec)).get(0).getName();
        StreamTableColWStreamName col = this.findTableColumnMayByPrefixed(streamTypeService, unresolvedPropertyName);
        if (col == null) {
            return null;
        }
        StreamTableColPair pair = col.getPair();
        if (pair.getColumn() instanceof TableMetadataColumnAggregation) {
            String candidateAccessor;
            ExprAggregateNodeBase exprNode;
            TableMetadataColumnAggregation agg = (TableMetadataColumnAggregation)pair.getColumn();
            if (chainSpec.size() > 1 && (exprNode = (ExprAggregateNodeBase)ASTAggregationHelper.tryResolveAsAggregation(engineImportService, false, candidateAccessor = chainSpec.get(1).getName(), new LazyAllocatedMap<ConfigurationPlugInAggregationMultiFunction, PlugInAggregationMultiFunctionFactory>(), streamTypeService.getEngineURIQualifier())) != null) {
                ExprTableIdentNodeSubpropAccessor node = new ExprTableIdentNodeSubpropAccessor(pair.getStreamNum(), col.getOptionalStreamName(), agg, exprNode);
                exprNode.addChildNodes(chainSpec.get(1).getParameters());
                chainSpec.remove(0);
                chainSpec.remove(0);
                return new Pair<ExprNode, List<ExprChainedSpec>>(node, chainSpec);
            }
            ExprTableIdentNode node = new ExprTableIdentNode(null, unresolvedPropertyName);
            ExprEvaluator eval = ExprTableEvalStrategyFactory.getTableAccessEvalStrategy(node, pair.getTableMetadata().getTableName(), pair.getStreamNum(), agg);
            node.setEval(eval);
            chainSpec.remove(0);
            return new Pair<ExprNode, List<ExprChainedSpec>>(node, chainSpec);
        }
        return null;
    }

    @Override
    public ExprTableIdentNode getTableIdentNode(StreamTypeService streamTypeService, String unresolvedPropertyName, String streamOrPropertyName) throws ExprValidationException {
        StreamTableColWStreamName col;
        String propertyPrefixed = unresolvedPropertyName;
        if (streamOrPropertyName != null) {
            propertyPrefixed = streamOrPropertyName + "." + unresolvedPropertyName;
        }
        if ((col = this.findTableColumnMayByPrefixed(streamTypeService, propertyPrefixed)) == null) {
            return null;
        }
        StreamTableColPair pair = col.getPair();
        if (pair.getColumn() instanceof TableMetadataColumnAggregation) {
            TableMetadataColumnAggregation agg = (TableMetadataColumnAggregation)pair.getColumn();
            ExprTableIdentNode node = new ExprTableIdentNode(streamOrPropertyName, unresolvedPropertyName);
            ExprEvaluator eval = ExprTableEvalStrategyFactory.getTableAccessEvalStrategy(node, pair.getTableMetadata().getTableName(), pair.getStreamNum(), agg);
            node.setEval(eval);
            return node;
        }
        return null;
    }

    @Override
    public void addTableUpdateStrategyReceiver(TableMetadata tableMetadata, String statementName, TableUpdateStrategyReceiver receiver, EventBeanUpdateHelper updateHelper, boolean isOnMerge) {
        tableMetadata.addTableUpdateStrategyReceiver(statementName, receiver, updateHelper, isOnMerge);
    }

    @Override
    public void removeTableUpdateStrategyReceivers(TableMetadata tableMetadata, String statementName) {
        tableMetadata.removeTableUpdateStrategyReceivers(statementName);
    }

    @Override
    public String[] getTables() {
        return CollectionUtil.toArray(this.tables.keySet());
    }

    @Override
    public TableAndLockProvider getStateProvider(String tableName, int agentInstanceId, boolean writesToTables) {
        Lock lock;
        TableStateInstance instance = this.assertGetState(tableName, agentInstanceId);
        Lock lock2 = lock = writesToTables ? instance.getTableLevelRWLock().writeLock() : instance.getTableLevelRWLock().readLock();
        if (instance instanceof TableStateInstanceGrouped) {
            return new TableAndLockProviderGroupedImpl(new TableAndLockGrouped(lock, (TableStateInstanceGrouped)((Object)instance)));
        }
        return new TableAndLockProviderUngroupedImpl(new TableAndLockUngrouped(lock, (TableStateInstanceUngrouped)((Object)instance)));
    }

    private StreamTableColWStreamName findTableColumnMayByPrefixed(StreamTypeService streamTypeService, String streamAndPropName) throws ExprValidationException {
        int indexDot = streamAndPropName.indexOf(".");
        if (indexDot == -1) {
            StreamTableColPair pair = this.findTableColumnAcrossStreams(streamTypeService, streamAndPropName);
            if (pair != null) {
                return new StreamTableColWStreamName(pair, null);
            }
        } else {
            String streamName = streamAndPropName.substring(0, indexDot);
            String colName = streamAndPropName.substring(indexDot + 1);
            int streamNum = streamTypeService.getStreamNumForStreamName(streamName);
            if (streamNum == -1) {
                return null;
            }
            StreamTableColPair pair = this.findTableColumnForType(streamNum, streamTypeService.getEventTypes()[streamNum], colName);
            if (pair != null) {
                return new StreamTableColWStreamName(pair, streamName);
            }
        }
        return null;
    }

    @Override
    public void removeIndexReferencesStmtMayRemoveIndex(String statementName, TableMetadata tableMetadata) {
        tableMetadata.removeIndexReferencesStatement(statementName);
    }

    private StreamTableColPair findTableColumnAcrossStreams(StreamTypeService streamTypeService, String columnName) throws ExprValidationException {
        StreamTableColPair found = null;
        for (int i = 0; i < streamTypeService.getEventTypes().length; ++i) {
            EventType type = streamTypeService.getEventTypes()[i];
            StreamTableColPair pair = this.findTableColumnForType(i, type, columnName);
            if (pair == null) continue;
            if (found != null) {
                if (streamTypeService.isStreamZeroUnambigous() && found.getStreamNum() == 0) continue;
                throw new ExprValidationException("Ambiguous table column '" + columnName + "' should be prefixed by a stream name");
            }
            found = pair;
        }
        return found;
    }

    private StreamTableColPair findTableColumnForType(int streamNum, EventType type, String columnName) {
        TableMetadataColumn column;
        TableMetadata tableMetadata = this.getTableMetadataFromEventType(type);
        if (tableMetadata != null && (column = tableMetadata.getTableColumns().get(columnName)) != null) {
            return new StreamTableColPair(streamNum, column, tableMetadata);
        }
        return null;
    }

    private static class StreamTableColWStreamName {
        private final StreamTableColPair pair;
        private final String optionalStreamName;

        private StreamTableColWStreamName(StreamTableColPair pair, String optionalStreamName) {
            this.pair = pair;
            this.optionalStreamName = optionalStreamName;
        }

        public StreamTableColPair getPair() {
            return this.pair;
        }

        public String getOptionalStreamName() {
            return this.optionalStreamName;
        }
    }

    private static class StreamTableColPair {
        private final int streamNum;
        private final TableMetadataColumn column;
        private final TableMetadata tableMetadata;

        private StreamTableColPair(int streamNum, TableMetadataColumn column, TableMetadata tableMetadata) {
            this.streamNum = streamNum;
            this.column = column;
            this.tableMetadata = tableMetadata;
        }

        public int getStreamNum() {
            return this.streamNum;
        }

        public TableMetadataColumn getColumn() {
            return this.column;
        }

        public TableMetadata getTableMetadata() {
            return this.tableMetadata;
        }
    }
}

