/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.upd;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.table.upd.TableUpdateStrategy;
import com.espertech.esper.epl.updatehelper.EventBeanUpdateHelper;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import com.espertech.esper.event.arr.ObjectArrayEventBean;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class TableUpdateStrategyIndexNonUnique
implements TableUpdateStrategy {
    private final EventBeanUpdateHelper updateHelper;
    private final Set<String> affectedIndexNames;

    public TableUpdateStrategyIndexNonUnique(EventBeanUpdateHelper updateHelper, Set<String> affectedIndexNames) {
        this.updateHelper = updateHelper;
        this.affectedIndexNames = affectedIndexNames;
    }

    @Override
    public void updateTable(Collection<EventBean> eventsUnsafeIter, TableStateInstance instance, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] events = new EventBean[eventsUnsafeIter.size()];
        int count = 0;
        for (EventBean event : eventsUnsafeIter) {
            events[count++] = event;
        }
        for (String affectedIndexName : this.affectedIndexNames) {
            EventTable index = instance.getIndex(affectedIndexName);
            index.remove(events, (ExprEvaluatorContext)instance.getAgentInstanceContext());
        }
        for (Iterator<Object> iterator : events) {
            eventsPerStream[0] = iterator;
            ObjectArrayBackedEventBean updatedEvent = (ObjectArrayBackedEventBean)((Object)iterator);
            if (this.updateHelper.isRequiresStream2InitialValueEvent()) {
                Object[] prev = new Object[updatedEvent.getProperties().length];
                System.arraycopy(updatedEvent.getProperties(), 0, prev, 0, prev.length);
                eventsPerStream[2] = new ObjectArrayEventBean(prev, updatedEvent.getEventType());
            }
            this.updateHelper.updateNoCopy(updatedEvent, eventsPerStream, exprEvaluatorContext);
            instance.handleRowUpdated(updatedEvent);
        }
        for (String affectedIndexName : this.affectedIndexNames) {
            EventTable index = instance.getIndex(affectedIndexName);
            index.add(events, (ExprEvaluatorContext)instance.getAgentInstanceContext());
        }
    }
}

