/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.variable;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.OnTriggerSetDesc;
import com.espertech.esper.epl.variable.OnSetVariableView;
import com.espertech.esper.epl.variable.VariableReadWritePackage;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnSetVariableViewFactory {
    private static final Logger log = LoggerFactory.getLogger(OnSetVariableViewFactory.class);
    private final EventAdapterService eventAdapterService;
    private final VariableService variableService;
    private final EventType eventType;
    private VariableReadWritePackage variableReadWritePackage;
    private final StatementResultService statementResultService;

    public OnSetVariableViewFactory(int statementId, OnTriggerSetDesc desc, EventAdapterService eventAdapterService, VariableService variableService, StatementResultService statementResultService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        this.eventAdapterService = eventAdapterService;
        this.variableService = variableService;
        this.statementResultService = statementResultService;
        this.variableReadWritePackage = new VariableReadWritePackage(desc.getAssignments(), variableService, eventAdapterService);
        String outputEventTypeName = statementId + "_outsetvar";
        this.eventType = eventAdapterService.createAnonymousMapType(outputEventTypeName, this.variableReadWritePackage.getVariableTypes(), true);
    }

    public OnSetVariableView instantiate(ExprEvaluatorContext exprEvaluatorContext) {
        return new OnSetVariableView(this, exprEvaluatorContext);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public EventAdapterService getEventAdapterService() {
        return this.eventAdapterService;
    }

    public VariableService getVariableService() {
        return this.variableService;
    }

    public VariableReadWritePackage getVariableReadWritePackage() {
        return this.variableReadWritePackage;
    }

    public StatementResultService getStatementResultService() {
        return this.statementResultService;
    }
}

