/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionBase;
import com.espertech.esper.schedule.ScheduleComputeHelper;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputConditionCrontab
extends OutputConditionBase
implements OutputCondition {
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = true;
    private final AgentInstanceContext context;
    private final ScheduleSpec scheduleSpec;
    private final long scheduleSlot;
    private Long currentReferencePoint;
    private boolean isCallbackScheduled;
    private static final Logger log = LoggerFactory.getLogger(OutputConditionCrontab.class);

    public OutputConditionCrontab(OutputCallback outputCallback, AgentInstanceContext context, boolean isStartConditionOnCreation, ScheduleSpec scheduleSpec) {
        super(outputCallback);
        this.context = context;
        this.scheduleSpec = scheduleSpec;
        this.scheduleSlot = context.getStatementContext().getScheduleBucket().allocateSlot();
        if (isStartConditionOnCreation) {
            this.updateOutputCondition(0, 0);
        }
    }

    @Override
    public final void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount);
        }
        if (this.currentReferencePoint == null) {
            this.currentReferencePoint = this.context.getStatementContext().getSchedulingService().getTime();
        }
        if (!this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    public final String toString() {
        return this.getClass().getName() + " spec=" + this.scheduleSpec;
    }

    private void scheduleCallback() {
        this.isCallbackScheduled = true;
        long current = this.context.getStatementContext().getSchedulingService().getTime();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".scheduleCallback Scheduled new callback for  now=" + current + " currentReferencePoint=" + this.currentReferencePoint + " spec=" + this.scheduleSpec);
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(EngineLevelExtensionServicesContext extensionServicesContext) {
                OutputConditionCrontab.this.isCallbackScheduled = false;
                OutputConditionCrontab.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionCrontab.this.scheduleCallback();
            }
        };
        EPStatementHandleCallback handle = new EPStatementHandleCallback(this.context.getEpStatementAgentInstanceHandle(), callback);
        SchedulingService schedulingService = this.context.getStatementContext().getSchedulingService();
        EngineImportService engineImportService = this.context.getStatementContext().getEngineImportService();
        long nextScheduledTime = ScheduleComputeHelper.computeDeltaNextOccurance(this.scheduleSpec, schedulingService.getTime(), engineImportService.getTimeZone(), engineImportService.getTimeAbacus());
        schedulingService.add(nextScheduledTime, handle, this.scheduleSlot);
    }

    @Override
    public void terminated() {
        this.outputCallback.continueOutputProcessing(true, true);
    }

    @Override
    public void stop() {
    }
}

