/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledCount;
import com.espertech.esper.epl.view.OutputConditionPolledCountState;
import com.espertech.esper.epl.view.OutputConditionPolledFactory;
import com.espertech.esper.epl.view.OutputConditionPolledState;

public final class OutputConditionPolledCountFactory
implements OutputConditionPolledFactory {
    private final int eventRate;
    private final StatementContext statementContext;
    private final String variableName;

    public OutputConditionPolledCountFactory(int eventRate, StatementContext statementContext, String variableName) {
        if (eventRate < 1 && variableName == null) {
            throw new IllegalArgumentException("Limiting output by event count requires an event count of at least 1 or a variable name");
        }
        this.eventRate = eventRate;
        this.statementContext = statementContext;
        this.variableName = variableName;
    }

    @Override
    public OutputConditionPolled makeNew(AgentInstanceContext agentInstanceContext) {
        OutputConditionPolledCountState state = new OutputConditionPolledCountState(this.eventRate, this.eventRate, this.eventRate, true);
        return new OutputConditionPolledCount(this, state, this.getVariableReader(agentInstanceContext));
    }

    @Override
    public OutputConditionPolled makeFromState(AgentInstanceContext agentInstanceContext, OutputConditionPolledState state) {
        return new OutputConditionPolledCount(this, (OutputConditionPolledCountState)state, this.getVariableReader(agentInstanceContext));
    }

    private VariableReader getVariableReader(AgentInstanceContext agentInstanceContext) {
        if (this.variableName == null) {
            return null;
        }
        return this.statementContext.getVariableService().getReader(this.variableName, agentInstanceContext.getAgentInstanceId());
    }
}

