/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.view.OutputConditionExpressionTypeUtil;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledExpressionFactory;
import com.espertech.esper.epl.view.OutputConditionPolledExpressionState;
import com.espertech.esper.epl.view.OutputConditionPolledState;
import com.espertech.esper.event.arr.ObjectArrayEventBean;

public class OutputConditionPolledExpression
implements OutputConditionPolled {
    private final OutputConditionPolledExpressionFactory factory;
    private final OutputConditionPolledExpressionState state;
    private final AgentInstanceContext agentInstanceContext;
    private ObjectArrayEventBean builtinProperties;
    private EventBean[] eventsPerStream = new EventBean[1];

    public OutputConditionPolledExpression(OutputConditionPolledExpressionFactory factory, OutputConditionPolledExpressionState state, AgentInstanceContext agentInstanceContext, ObjectArrayEventBean builtinProperties) {
        this.factory = factory;
        this.state = state;
        this.builtinProperties = builtinProperties;
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public OutputConditionPolledState getState() {
        return this.state;
    }

    @Override
    public boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        this.state.setTotalNewEventsCount(this.state.getTotalNewEventsCount() + newEventsCount);
        this.state.setTotalOldEventsCount(this.state.getTotalOldEventsCount() + oldEventsCount);
        this.state.setTotalNewEventsSum(this.state.getTotalNewEventsSum() + newEventsCount);
        this.state.setTotalOldEventsSum(this.state.getTotalOldEventsCount() + oldEventsCount);
        boolean isOutput = this.evaluate();
        if (isOutput) {
            this.resetBuiltinProperties();
            if (this.factory.getVariableReadWritePackage() != null) {
                if (this.builtinProperties != null) {
                    this.populateBuiltinProperties();
                    this.eventsPerStream[0] = this.builtinProperties;
                }
                this.factory.getVariableReadWritePackage().writeVariables(this.agentInstanceContext.getStatementContext().getVariableService(), this.eventsPerStream, null, this.agentInstanceContext);
            }
        }
        return isOutput;
    }

    private void populateBuiltinProperties() {
        OutputConditionExpressionTypeUtil.populate(this.builtinProperties.getProperties(), this.state.getTotalNewEventsCount(), this.state.getTotalOldEventsCount(), this.state.getTotalNewEventsSum(), this.state.getTotalOldEventsSum(), this.state.getLastOutputTimestamp());
    }

    private boolean evaluate() {
        if (this.builtinProperties != null) {
            this.populateBuiltinProperties();
            this.eventsPerStream[0] = this.builtinProperties;
        }
        boolean result = false;
        Boolean output = (Boolean)this.factory.getWhenExpressionNode().evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        if (output != null && output.booleanValue()) {
            result = true;
        }
        return result;
    }

    private void resetBuiltinProperties() {
        if (this.builtinProperties != null) {
            this.state.setTotalNewEventsCount(0);
            this.state.setTotalOldEventsCount(0);
            this.state.setLastOutputTimestamp(this.agentInstanceContext.getStatementContext().getSchedulingService().getTime());
        }
    }
}

