/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.view.OutputConditionPolledCountFactory;
import com.espertech.esper.epl.view.OutputConditionPolledCrontabFactory;
import com.espertech.esper.epl.view.OutputConditionPolledExpressionFactory;
import com.espertech.esper.epl.view.OutputConditionPolledFactory;
import com.espertech.esper.epl.view.OutputConditionPolledTimeFactory;
import com.espertech.esper.util.JavaClassHelper;

public class OutputConditionPolledFactoryFactory {
    public static OutputConditionPolledFactory createConditionFactory(OutputLimitSpec outputLimitSpec, StatementContext statementContext) throws ExprValidationException {
        if (outputLimitSpec == null) {
            throw new NullPointerException("Output condition by count requires a non-null callback");
        }
        VariableMetaData variableMetaData = null;
        if (outputLimitSpec.getVariableName() != null && (variableMetaData = statementContext.getVariableService().getVariableMetaData(outputLimitSpec.getVariableName())) == null) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' has not been declared");
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.CRONTAB) {
            return new OutputConditionPolledCrontabFactory(outputLimitSpec.getCrontabAtSchedule(), statementContext);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.WHEN_EXPRESSION) {
            return new OutputConditionPolledExpressionFactory(outputLimitSpec.getWhenExpressionNode(), outputLimitSpec.getThenExpressions(), statementContext);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.EVENTS) {
            int rate = -1;
            if (outputLimitSpec.getRate() != null) {
                rate = outputLimitSpec.getRate().intValue();
            }
            return new OutputConditionPolledCountFactory(rate, statementContext, outputLimitSpec.getVariableName());
        }
        if (variableMetaData != null && !JavaClassHelper.isNumeric(variableMetaData.getType())) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be of numeric type");
        }
        return new OutputConditionPolledTimeFactory(outputLimitSpec.getTimePeriodExpr(), statementContext);
    }
}

