/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorHelperFactory;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputProcessViewAfterState;
import com.espertech.esper.epl.view.OutputProcessViewBaseWAfter;
import com.espertech.esper.epl.view.OutputProcessViewConditionDeltaSet;
import com.espertech.esper.epl.view.OutputProcessViewConditionFactory;
import com.espertech.esper.epl.view.OutputStrategyUtil;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputProcessViewConditionLastAllUnord
extends OutputProcessViewBaseWAfter {
    private final OutputProcessViewConditionFactory parent;
    private final OutputCondition outputCondition;
    private final boolean isAll;
    private static final Logger log = LoggerFactory.getLogger(OutputProcessViewConditionLastAllUnord.class);

    public OutputProcessViewConditionLastAllUnord(ResultSetProcessorHelperFactory resultSetProcessorHelperFactory, ResultSetProcessor resultSetProcessor, Long afterConditionTime, Integer afterConditionNumberOfEvents, boolean afterConditionSatisfied, OutputProcessViewConditionFactory parent, AgentInstanceContext agentInstanceContext) {
        super(resultSetProcessorHelperFactory, agentInstanceContext, resultSetProcessor, afterConditionTime, afterConditionNumberOfEvents, afterConditionSatisfied);
        this.parent = parent;
        this.isAll = parent.getOutputLimitLimitType() == OutputLimitLimitType.ALL;
        OutputCallback outputCallback = this.getCallbackToLocal(parent.getStreamCount());
        this.outputCondition = parent.getOutputConditionFactory().make(agentInstanceContext, outputCallback);
    }

    @Override
    public int getNumChangesetRows() {
        return 0;
    }

    @Override
    public OutputCondition getOptionalOutputCondition() {
        return this.outputCondition;
    }

    @Override
    public OutputProcessViewConditionDeltaSet getOptionalDeltaSet() {
        return null;
    }

    @Override
    public OutputProcessViewAfterState getOptionalAfterConditionState() {
        return null;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
        this.resultSetProcessor.processOutputLimitedLastAllNonBufferedView(newData, oldData, isGenerateSynthetic, this.isAll);
        if (!super.checkAfterCondition(newData, this.parent.getStatementContext())) {
            return;
        }
        int newDataLength = 0;
        int oldDataLength = 0;
        if (newData != null) {
            newDataLength = newData.length;
        }
        if (oldData != null) {
            oldDataLength = oldData.length;
        }
        this.outputCondition.updateOutputCondition(newDataLength, oldDataLength);
    }

    @Override
    public void process(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".process Received update,   newData.length==" + (newEvents == null ? 0 : newEvents.size()) + "  oldData.length==" + (oldEvents == null ? 0 : oldEvents.size()));
        }
        boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
        this.resultSetProcessor.processOutputLimitedLastAllNonBufferedJoin(newEvents, oldEvents, isGenerateSynthetic, this.isAll);
        if (!super.checkAfterCondition(newEvents, this.parent.getStatementContext())) {
            return;
        }
        int newEventsSize = 0;
        if (newEvents != null) {
            newEventsSize = newEvents.size();
        }
        int oldEventsSize = 0;
        if (oldEvents != null) {
            oldEventsSize = oldEvents.size();
        }
        this.outputCondition.updateOutputCondition(newEventsSize, oldEventsSize);
    }

    protected void continueOutputProcessingView(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".continueOutputProcessingView");
        }
        boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.continueOutputLimitedLastAllNonBufferedView(isGenerateSynthetic, this.isAll);
        this.continueOutputProcessingViewAndJoin(doOutput, forceUpdate, newOldEvents);
    }

    protected void output(boolean forceUpdate, UniformPair<EventBean[]> results) {
        if (this.childView != null) {
            OutputStrategyUtil.output(forceUpdate, results, this.childView);
        }
    }

    protected void continueOutputProcessingJoin(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".continueOutputProcessingJoin");
        }
        boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.continueOutputLimitedLastAllNonBufferedJoin(isGenerateSynthetic, this.isAll);
        this.continueOutputProcessingViewAndJoin(doOutput, forceUpdate, newOldEvents);
    }

    private OutputCallback getCallbackToLocal(int streamCount) {
        if (streamCount == 1) {
            return new OutputCallback(){

                @Override
                public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                    OutputProcessViewConditionLastAllUnord.this.continueOutputProcessingView(doOutput, forceUpdate);
                }
            };
        }
        return new OutputCallback(){

            @Override
            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputProcessViewConditionLastAllUnord.this.continueOutputProcessingJoin(doOutput, forceUpdate);
            }
        };
    }

    @Override
    public Iterator<EventBean> iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, this.parent.isDistinct());
    }

    @Override
    public void terminated() {
        if (this.parent.isTerminable()) {
            this.outputCondition.terminated();
        }
    }

    private void continueOutputProcessingViewAndJoin(boolean doOutput, boolean forceUpdate, UniformPair<EventBean[]> newOldEvents) {
        if (this.parent.isDistinct() && newOldEvents != null) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getEventBeanReader()));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getEventBeanReader()));
        }
        if (doOutput) {
            this.output(forceUpdate, newOldEvents);
        }
    }
}

