/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.arr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.codegen.core.CodegenContext;
import com.espertech.esper.codegen.core.CodegenMember;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.event.bean.BeanEventType;

public class ObjectArrayEntryPropertyGetter
implements ObjectArrayEventPropertyGetter {
    private final int propertyIndex;
    private final EventAdapterService eventAdapterService;
    private final BeanEventType eventType;

    public ObjectArrayEntryPropertyGetter(int propertyIndex, BeanEventType eventType, EventAdapterService eventAdapterService) {
        this.propertyIndex = propertyIndex;
        this.eventAdapterService = eventAdapterService;
        this.eventType = eventType;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        return array[this.propertyIndex];
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        Object[] arr = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(obj);
        return this.getObjectArray(arr);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        if (this.eventType == null) {
            return null;
        }
        Object result = this.get(eventBean);
        return BaseNestableEventUtil.getBNFragmentPojo(result, this.eventType, this.eventAdapterService);
    }

    @Override
    public CodegenExpression codegenEventBeanGet(CodegenExpression beanExpression, CodegenContext context) {
        return CodegenExpressionBuilder.beanUndCastArrayAtIndex(Object[].class, beanExpression, this.propertyIndex);
    }

    @Override
    public CodegenExpression codegenEventBeanExists(CodegenExpression beanExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenEventBeanFragment(CodegenExpression beanExpression, CodegenContext context) {
        if (this.eventType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        return this.codegenUnderlyingFragment(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenUnderlyingGet(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.arrayAtIndex(underlyingExpression, CodegenExpressionBuilder.constant(this.propertyIndex));
    }

    @Override
    public CodegenExpression codegenUnderlyingExists(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenUnderlyingFragment(CodegenExpression underlyingExpression, CodegenContext context) {
        if (this.eventType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenMember mSvc = context.makeAddMember(EventAdapterService.class, this.eventAdapterService);
        CodegenMember mType = context.makeAddMember(BeanEventType.class, this.eventType);
        return CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNFragmentPojo", this.codegenUnderlyingGet(underlyingExpression, context), CodegenExpressionBuilder.ref(mType.getMemberName()), CodegenExpressionBuilder.ref(mSvc.getMemberName()));
    }
}

