/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.arr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.codegen.core.CodegenContext;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.util.Map;

public class ObjectArrayMapPropertyGetter
implements ObjectArrayEventPropertyGetter {
    private final int index;
    private final MapEventPropertyGetter getter;

    public ObjectArrayMapPropertyGetter(int index, MapEventPropertyGetter getter) {
        if (getter == null) {
            throw new IllegalArgumentException("Getter is a required parameter");
        }
        this.index = index;
        this.getter = getter;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        Object valueTopObj = array[this.index];
        if (!(valueTopObj instanceof Map)) {
            return null;
        }
        return this.getter.getMap((Map)valueTopObj);
    }

    private String getObjectArrayCodegen(CodegenContext context) {
        return context.addMethod(Object.class, Object[].class, "array", this.getClass()).declareVar(Object.class, "valueTopObj", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.constant(this.index))).ifRefNotTypeReturnConst("valueTopObj", Map.class, null).methodReturn(this.getter.codegenUnderlyingGet(CodegenExpressionBuilder.cast(Map.class, CodegenExpressionBuilder.ref("valueTopObj")), context));
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        Object valueTopObj = array[this.index];
        if (!(valueTopObj instanceof Map)) {
            return false;
        }
        return this.getter.isMapExistsProperty((Map)valueTopObj);
    }

    private String isObjectArrayExistsPropertyCodegen(CodegenContext context) {
        return context.addMethod(Boolean.TYPE, Object[].class, "array", this.getClass()).declareVar(Object.class, "valueTopObj", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.constant(this.index))).ifRefNotTypeReturnConst("valueTopObj", Map.class, false).methodReturn(this.getter.codegenUnderlyingExists(CodegenExpressionBuilder.cast(Map.class, CodegenExpressionBuilder.ref("valueTopObj")), context));
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.getObjectArray(array);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.isObjectArrayExistsProperty(array);
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }

    @Override
    public CodegenExpression codegenEventBeanGet(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingGet(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenEventBeanExists(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingExists(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenEventBeanFragment(CodegenExpression beanExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression codegenUnderlyingGet(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.localMethod(this.getObjectArrayCodegen(context), underlyingExpression);
    }

    @Override
    public CodegenExpression codegenUnderlyingExists(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.localMethod(this.isObjectArrayExistsPropertyCodegen(context), underlyingExpression);
    }

    @Override
    public CodegenExpression codegenUnderlyingFragment(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantNull();
    }
}

