/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.bean.BeanEventType;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanEventBeanConfiguredCopyMethod
implements EventBeanCopyMethod {
    private static final Logger log = LoggerFactory.getLogger(BeanEventBeanConfiguredCopyMethod.class);
    private final BeanEventType beanEventType;
    private final EventAdapterService eventAdapterService;
    private final FastMethod copyMethod;

    public BeanEventBeanConfiguredCopyMethod(BeanEventType beanEventType, EventAdapterService eventAdapterService, FastMethod copyMethod) {
        this.beanEventType = beanEventType;
        this.eventAdapterService = eventAdapterService;
        this.copyMethod = copyMethod;
    }

    @Override
    public EventBean copy(EventBean theEvent) {
        Object copied;
        Object underlying = theEvent.getUnderlying();
        try {
            copied = this.copyMethod.invoke(underlying, null);
        }
        catch (InvocationTargetException e) {
            log.error("InvocationTargetException copying event object for update: " + e.getMessage(), (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            log.error("RuntimeException copying event object for update: " + e.getMessage(), (Throwable)e);
            return null;
        }
        return this.eventAdapterService.adapterForTypedBean(copied, this.beanEventType);
    }
}

