/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.DynamicPropertyDescriptor;
import com.espertech.esper.event.bean.DynamicPropertyGetterBase;
import com.espertech.esper.event.bean.PropertyHelper;
import com.espertech.esper.event.vaevent.PropertyUtility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DynamicSimplePropertyGetter
extends DynamicPropertyGetterBase {
    private final String getterMethodName;
    private final String isMethodName;

    public DynamicSimplePropertyGetter(String fieldName, EventAdapterService eventAdapterService) {
        super(eventAdapterService);
        this.getterMethodName = PropertyHelper.getGetterMethodName(fieldName);
        this.isMethodName = PropertyHelper.getIsMethodName(fieldName);
    }

    @Override
    protected Object call(DynamicPropertyDescriptor descriptor, Object underlying) {
        try {
            return descriptor.getMethod().invoke(underlying, null);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod().getJavaMethod(), underlying, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod().getJavaMethod(), e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod().getJavaMethod(), e);
        }
    }

    @Override
    protected Method determineMethod(Class clazz) {
        try {
            return clazz.getMethod(this.getterMethodName, new Class[0]);
        }
        catch (NoSuchMethodException ex1) {
            try {
                return clazz.getMethod(this.isMethodName, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
    }
}

