/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.codegen.core.CodegenContext;
import com.espertech.esper.codegen.core.CodegenMember;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import com.espertech.esper.event.map.MapEventPropertyGetterAndIndexed;
import java.util.Map;

public class MapArrayPropertyGetter
implements MapEventPropertyGetter,
MapEventPropertyGetterAndIndexed {
    private final String propertyName;
    private final int index;
    private final EventAdapterService eventAdapterService;
    private final EventType fragmentType;

    public MapArrayPropertyGetter(String propertyNameAtomic, int index, EventAdapterService eventAdapterService, EventType fragmentType) {
        this.propertyName = propertyNameAtomic;
        this.index = index;
        this.fragmentType = fragmentType;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        return this.getMapInternal(map, this.index);
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        Map<String, Object> map = BaseNestableEventUtil.checkedCastUnderlyingMap(eventBean);
        return this.getMapInternal(map, index);
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        Map<String, Object> map = BaseNestableEventUtil.checkedCastUnderlyingMap(obj);
        return this.getMap(map);
    }

    private Object getMapInternal(Map<String, Object> map, int index) throws PropertyAccessException {
        Object value = map.get(this.propertyName);
        return BaseNestableEventUtil.getBNArrayValueAtIndexWithNullCheck(value, index);
    }

    private String getMapInternalCodegen(CodegenContext context) {
        return context.addMethod(Object.class, Map.class, "map", this.getClass()).declareVar(Object.class, "value", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("map"), "get", CodegenExpressionBuilder.constant(this.propertyName))).methodReturn(CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNArrayValueAtIndexWithNullCheck", CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.constant(this.index)));
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean obj) throws PropertyAccessException {
        Object value = this.get(obj);
        return BaseNestableEventUtil.getBNFragmentNonPojo(value, this.fragmentType, this.eventAdapterService);
    }

    private String getFragmentCodegen(CodegenContext context) {
        CodegenMember mSvc = context.makeAddMember(EventAdapterService.class, this.eventAdapterService);
        CodegenMember mType = context.makeAddMember(EventType.class, this.fragmentType);
        return context.addMethod(Object.class, Map.class, "map", this.getClass()).declareVar(Object.class, "value", this.codegenUnderlyingGet(CodegenExpressionBuilder.ref("map"), context)).methodReturn(CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNFragmentNonPojo", CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref(mType.getMemberName()), CodegenExpressionBuilder.ref(mSvc.getMemberName())));
    }

    @Override
    public CodegenExpression codegenEventBeanGet(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingGet(CodegenExpressionBuilder.castUnderlying(Map.class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenEventBeanExists(CodegenExpression beanExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenEventBeanFragment(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingFragment(CodegenExpressionBuilder.castUnderlying(Map.class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenUnderlyingGet(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.localMethod(this.getMapInternalCodegen(context), underlyingExpression);
    }

    @Override
    public CodegenExpression codegenUnderlyingExists(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenUnderlyingFragment(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.localMethod(this.getFragmentCodegen(context), underlyingExpression);
    }
}

