/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.codegen.core.CodegenContext;
import com.espertech.esper.codegen.core.CodegenMember;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.util.Map;

public class MapFragmentArrayPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyName;
    private final EventType fragmentEventType;
    private final EventAdapterService eventAdapterService;

    public MapFragmentArrayPropertyGetter(String propertyNameAtomic, EventType fragmentEventType, EventAdapterService eventAdapterService) {
        this.propertyName = propertyNameAtomic;
        this.fragmentEventType = fragmentEventType;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        return map.get(this.propertyName);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        return this.getMap(BaseNestableEventUtil.checkedCastUnderlyingMap(obj));
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        Object value = this.get(eventBean);
        if (value instanceof EventBean[]) {
            return value;
        }
        return BaseNestableEventUtil.getBNFragmentArray(value, this.fragmentEventType, this.eventAdapterService);
    }

    private String getFragmentCodegen(CodegenContext context) {
        CodegenMember mSvc = context.makeAddMember(EventAdapterService.class, this.eventAdapterService);
        CodegenMember mType = context.makeAddMember(EventType.class, this.fragmentEventType);
        return context.addMethod(Object.class, Map.class, "map", this.getClass()).declareVar(Object.class, "value", this.codegenUnderlyingGet(CodegenExpressionBuilder.ref("map"), context)).ifInstanceOf("value", EventBean[].class).blockReturn(CodegenExpressionBuilder.ref("value")).methodReturn(CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNFragmentArray", CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref(mType.getMemberName()), CodegenExpressionBuilder.ref(mSvc.getMemberName())));
    }

    @Override
    public CodegenExpression codegenEventBeanGet(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingGet(CodegenExpressionBuilder.castUnderlying(Map.class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenEventBeanExists(CodegenExpression beanExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenEventBeanFragment(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingFragment(CodegenExpressionBuilder.castUnderlying(Map.class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenUnderlyingGet(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.exprDotMethod(underlyingExpression, "get", CodegenExpressionBuilder.constant(this.propertyName));
    }

    @Override
    public CodegenExpression codegenUnderlyingExists(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenUnderlyingFragment(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.localMethod(this.getFragmentCodegen(context), underlyingExpression);
    }
}

