/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.property;

import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.parse.ExceptionConvertor;
import com.espertech.esper.epl.parse.NoCaseSensitiveStream;
import com.espertech.esper.epl.parse.ParseHelper;
import com.espertech.esper.event.property.DynamicIndexedProperty;
import com.espertech.esper.event.property.DynamicMappedProperty;
import com.espertech.esper.event.property.DynamicSimpleProperty;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.NestedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.SimpleProperty;
import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.StringValue;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyParser {
    private static final Logger log = LoggerFactory.getLogger(PropertyParser.class);
    private static Set<String> keywordCache;

    public static Property parseAndWalk(String property, boolean isRootedDynamic) {
        return PropertyParser.walk(PropertyParser.parse(property), isRootedDynamic);
    }

    public static Property parseAndWalkLaxToSimple(String property) {
        try {
            return PropertyParser.walk(PropertyParser.parse(property), false);
        }
        catch (PropertyAccessException p) {
            return new SimpleProperty(property);
        }
    }

    public static Property walk(EsperEPL2GrammarParser.StartEventPropertyRuleContext tree, boolean isRootedDynamic) {
        if (tree.eventProperty().eventPropertyAtomic().size() == 1) {
            return PropertyParser.makeProperty(tree.eventProperty().eventPropertyAtomic(0), isRootedDynamic);
        }
        EsperEPL2GrammarParser.EventPropertyContext propertyRoot = tree.eventProperty();
        LinkedList<Property> properties = new LinkedList<Property>();
        boolean isRootedInDynamic = isRootedDynamic;
        for (EsperEPL2GrammarParser.EventPropertyAtomicContext atomic : propertyRoot.eventPropertyAtomic()) {
            Property property = PropertyParser.makeProperty(atomic, isRootedInDynamic);
            if (property instanceof DynamicSimpleProperty) {
                isRootedInDynamic = true;
            }
            properties.add(property);
        }
        return new NestedProperty(properties);
    }

    public static EsperEPL2GrammarParser.StartEventPropertyRuleContext parse(String propertyName) {
        EsperEPL2GrammarParser.StartEventPropertyRuleContext r;
        NoCaseSensitiveStream input;
        try {
            input = new NoCaseSensitiveStream(new StringReader(propertyName));
        }
        catch (IOException ex) {
            throw new PropertyAccessException("IOException parsing property name '" + propertyName + '\'', ex);
        }
        EsperEPL2GrammarLexer lex = ParseHelper.newLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        try {
            tokens.fill();
        }
        catch (RuntimeException e) {
            if (ParseHelper.hasControlCharacters(propertyName)) {
                throw new PropertyAccessException("Unrecognized control characters found in text");
            }
            throw new PropertyAccessException("Failed to parse text: " + e.getMessage());
        }
        EsperEPL2GrammarParser g = ParseHelper.newParser(tokens);
        try {
            r = g.startEventPropertyRule();
        }
        catch (RecognitionException e) {
            return PropertyParser.handleRecognitionEx(e, tokens, propertyName, g);
        }
        catch (RuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error parsing property expression [" + propertyName + "]", (Throwable)e);
            }
            if (e.getCause() instanceof RecognitionException) {
                return PropertyParser.handleRecognitionEx((RecognitionException)e.getCause(), tokens, propertyName, g);
            }
            throw e;
        }
        return r;
    }

    private static EsperEPL2GrammarParser.StartEventPropertyRuleContext handleRecognitionEx(RecognitionException e, CommonTokenStream tokens, String propertyName, EsperEPL2GrammarParser g) {
        NoCaseSensitiveStream inputEscaped;
        String escapedPropertyName = PropertyParser.escapeKeywords(tokens);
        try {
            inputEscaped = new NoCaseSensitiveStream(new StringReader(escapedPropertyName));
        }
        catch (IOException ex) {
            throw new PropertyAccessException("IOException parsing property name '" + propertyName + '\'', ex);
        }
        EsperEPL2GrammarLexer lexEscaped = ParseHelper.newLexer((CharStream)inputEscaped);
        CommonTokenStream tokensEscaped = new CommonTokenStream((TokenSource)lexEscaped);
        EsperEPL2GrammarParser gEscaped = ParseHelper.newParser(tokensEscaped);
        try {
            return gEscaped.startEventPropertyRule();
        }
        catch (Exception exception) {
            throw ExceptionConvertor.convertProperty(e, propertyName, true, g);
        }
    }

    private static synchronized String escapeKeywords(CommonTokenStream tokens) {
        Object token;
        Token t;
        if (keywordCache == null) {
            keywordCache = new HashSet<String>();
            Set<String> keywords = ParseHelper.newParser(tokens).getKeywords();
            for (String keyword : keywords) {
                if (keyword.charAt(0) != '\'' || keyword.charAt(keyword.length() - 1) != '\'') continue;
                keywordCache.add(keyword.substring(1, keyword.length() - 1));
            }
        }
        StringWriter writer = new StringWriter();
        Iterator<Object> iterator = tokens.getTokens().iterator();
        while (iterator.hasNext() && (t = (Token)(token = iterator.next())).getType() != -1) {
            boolean isKeyword = keywordCache.contains(t.getText().toLowerCase(Locale.ENGLISH));
            if (isKeyword) {
                writer.append('`');
                writer.append(t.getText());
                writer.append('`');
                continue;
            }
            writer.append(t.getText());
        }
        return writer.toString();
    }

    public static boolean isPropertyDynamic(EsperEPL2GrammarParser.StartEventPropertyRuleContext ast) {
        List<EsperEPL2GrammarParser.EventPropertyAtomicContext> ctxs = ast.eventProperty().eventPropertyAtomic();
        for (EsperEPL2GrammarParser.EventPropertyAtomicContext ctx : ctxs) {
            if (ctx.q == null && ctx.q1 == null) continue;
            return true;
        }
        return false;
    }

    private static Property makeProperty(EsperEPL2GrammarParser.EventPropertyAtomicContext atomic, boolean isRootedInDynamic) {
        String prop = ASTUtil.unescapeDot(atomic.eventPropertyIdent().getText());
        if (prop.length() == 0) {
            throw new PropertyAccessException("Invalid zero-length string provided as an event property name");
        }
        if (atomic.lb != null) {
            int index = IntValue.parseString(atomic.ni.getText());
            if (!isRootedInDynamic && atomic.q == null) {
                return new IndexedProperty(prop, index);
            }
            return new DynamicIndexedProperty(prop, index);
        }
        if (atomic.lp != null) {
            String key = StringValue.parseString(atomic.s.getText());
            if (!isRootedInDynamic && atomic.q == null) {
                return new MappedProperty(prop, key);
            }
            return new DynamicMappedProperty(prop, key);
        }
        if (!isRootedInDynamic && atomic.q1 == null) {
            return new SimpleProperty(prop);
        }
        return new DynamicSimpleProperty(prop);
    }

    public static String unescapeBacktick(String unescapedPropertyName) {
        if (unescapedPropertyName.startsWith("`") && unescapedPropertyName.endsWith("`")) {
            return unescapedPropertyName.substring(1, unescapedPropertyName.length() - 1);
        }
        if (!unescapedPropertyName.contains("`")) {
            return unescapedPropertyName;
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(unescapedPropertyName);
        if (property instanceof NestedProperty) {
            StringWriter writer = new StringWriter();
            property.toPropertyEPL(writer);
            return writer.toString();
        }
        return unescapedPropertyName;
    }

    public static boolean isNestedPropertyWithNonSimpleLead(EsperEPL2GrammarParser.EventPropertyContext ctx) {
        if (ctx.eventPropertyAtomic().size() == 1) {
            return false;
        }
        EsperEPL2GrammarParser.EventPropertyAtomicContext atomic = ctx.eventPropertyAtomic().get(0);
        return atomic.lb != null || atomic.lp != null || atomic.q1 != null;
    }
}

