/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventPropertyGetterIndexed;
import com.espertech.esper.client.EventPropertyGetterMapped;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanWriter;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.EventPropertyWriter;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyBase;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.event.property.SimpleProperty;
import com.espertech.esper.event.vaevent.RevisionNestedPropertyGetter;
import com.espertech.esper.event.vaevent.RevisionPropertyTypeDesc;
import com.espertech.esper.util.JavaClassHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RevisionEventType
implements EventTypeSPI {
    private final EventTypeMetadata metadata;
    private final int eventTypeId;
    private String[] propertyNames;
    private EventPropertyDescriptor[] propertyDescriptors;
    private Map<String, EventPropertyDescriptor> propertyDescriptorMap;
    private Map<String, RevisionPropertyTypeDesc> propertyDesc;
    private EventAdapterService eventAdapterService;
    private Map<String, EventPropertyGetter> propertyGetterCodegeneratedCache;

    public RevisionEventType(EventTypeMetadata metadata, int eventTypeId, Map<String, RevisionPropertyTypeDesc> propertyDesc, EventAdapterService eventAdapterService) {
        this.metadata = metadata;
        this.eventTypeId = eventTypeId;
        this.propertyDesc = propertyDesc;
        Set<String> keys = propertyDesc.keySet();
        this.propertyNames = keys.toArray(new String[keys.size()]);
        this.eventAdapterService = eventAdapterService;
        this.propertyDescriptors = new EventPropertyDescriptor[propertyDesc.size()];
        this.propertyDescriptorMap = new HashMap<String, EventPropertyDescriptor>();
        int count = 0;
        for (Map.Entry<String, RevisionPropertyTypeDesc> desc : propertyDesc.entrySet()) {
            EventPropertyDescriptor descriptor;
            Class type = (Class)desc.getValue().getPropertyType();
            this.propertyDescriptors[count] = descriptor = new EventPropertyDescriptor(desc.getKey(), type, null, false, false, false, false, JavaClassHelper.isFragmentableType(type));
            this.propertyDescriptorMap.put(desc.getKey(), descriptor);
            ++count;
        }
    }

    @Override
    public int getEventTypeId() {
        return this.eventTypeId;
    }

    @Override
    public String getStartTimestampPropertyName() {
        return null;
    }

    @Override
    public String getEndTimestampPropertyName() {
        return null;
    }

    @Override
    public EventPropertyGetterSPI getGetterSPI(String propertyName) {
        RevisionPropertyTypeDesc desc = this.propertyDesc.get(propertyName);
        if (desc != null) {
            return desc.getRevisionGetter();
        }
        if (propertyName.indexOf(63) != -1) {
            return null;
        }
        int index = ASTUtil.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            PropertyBase indexedprop;
            Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyName);
            if (prop instanceof SimpleProperty) {
                return null;
            }
            String atomic = null;
            if (prop instanceof IndexedProperty) {
                indexedprop = (IndexedProperty)prop;
                atomic = indexedprop.getPropertyNameAtomic();
            }
            if (prop instanceof MappedProperty) {
                indexedprop = (MappedProperty)prop;
                atomic = indexedprop.getPropertyNameAtomic();
            }
            if ((desc = this.propertyDesc.get(atomic)) == null) {
                return null;
            }
            if (!(desc.getPropertyType() instanceof Class)) {
                return null;
            }
            Class nestedClass = (Class)desc.getPropertyType();
            BeanEventType complexProperty = (BeanEventType)this.eventAdapterService.addBeanType(nestedClass.getName(), nestedClass, false, false, false);
            return prop.getGetter(complexProperty, this.eventAdapterService);
        }
        String propertyMap = ASTUtil.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        desc = this.propertyDesc.get(propertyMap);
        if (desc == null) {
            return null;
        }
        if (desc.getPropertyType() instanceof Class) {
            Class simpleClass = (Class)desc.getPropertyType();
            EventTypeSPI nestedEventType = (EventTypeSPI)this.eventAdapterService.addBeanType(simpleClass.getName(), simpleClass, false, false, false);
            EventPropertyGetterSPI nestedGetter = nestedEventType.getGetterSPI(propertyNested);
            if (nestedGetter == null) {
                return null;
            }
            return new RevisionNestedPropertyGetter(desc.getRevisionGetter(), nestedGetter, this.eventAdapterService);
        }
        return null;
    }

    @Override
    public EventPropertyGetter getGetter(String propertyName) {
        EventPropertyGetter getter;
        if (!this.eventAdapterService.getEngineImportService().isCodegenEventPropertyGetters()) {
            return this.getGetterSPI(propertyName);
        }
        if (this.propertyGetterCodegeneratedCache == null) {
            this.propertyGetterCodegeneratedCache = new HashMap<String, EventPropertyGetter>();
        }
        if ((getter = this.propertyGetterCodegeneratedCache.get(propertyName)) != null) {
            return getter;
        }
        EventPropertyGetterSPI getterSPI = this.getGetterSPI(propertyName);
        if (getterSPI == null) {
            return null;
        }
        EventPropertyGetter getterCode = this.eventAdapterService.getEngineImportService().codegenGetter(getterSPI, propertyName);
        this.propertyGetterCodegeneratedCache.put(propertyName, getterCode);
        return getterCode;
    }

    @Override
    public String getName() {
        return this.metadata.getPublicName();
    }

    @Override
    public Class getPropertyType(String propertyName) {
        RevisionPropertyTypeDesc desc = this.propertyDesc.get(propertyName);
        if (desc != null) {
            if (desc.getPropertyType() instanceof Class) {
                return (Class)desc.getPropertyType();
            }
            return null;
        }
        if (propertyName.indexOf(63) != -1) {
            return null;
        }
        int index = ASTUtil.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            return null;
        }
        String propertyMap = ASTUtil.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        desc = this.propertyDesc.get(propertyMap);
        if (desc == null) {
            return null;
        }
        if (desc.getPropertyType() instanceof Class) {
            Class simpleClass = (Class)desc.getPropertyType();
            EventType nestedEventType = this.eventAdapterService.addBeanType(simpleClass.getName(), simpleClass, false, false, false);
            return nestedEventType.getPropertyType(propertyNested);
        }
        return null;
    }

    @Override
    public Class getUnderlyingType() {
        return RevisionEventType.class;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public boolean isProperty(String property) {
        return this.getPropertyType(property) != null;
    }

    @Override
    public EventType[] getSuperTypes() {
        return null;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return null;
    }

    @Override
    public EventTypeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public EventPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public FragmentEventType getFragmentType(String property) {
        return null;
    }

    @Override
    public EventPropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName);
    }

    @Override
    public EventPropertyWriter getWriter(String propertyName) {
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        return new EventPropertyDescriptor[0];
    }

    @Override
    public EventBeanCopyMethod getCopyMethod(String[] properties) {
        return null;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        return null;
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        return null;
    }

    @Override
    public EventBeanReader getReader() {
        return null;
    }

    @Override
    public EventPropertyGetterMapped getGetterMapped(String mappedProperty) {
        return null;
    }

    @Override
    public EventPropertyGetterIndexed getGetterIndexed(String indexedProperty) {
        return null;
    }

    @Override
    public boolean equalsCompareType(EventType eventType) {
        return this == eventType;
    }
}

