/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.codegen.core.CodegenContext;
import com.espertech.esper.codegen.core.CodegenMember;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.xml.DOMPropertyGetter;
import com.espertech.esper.util.SimpleTypeParser;
import com.espertech.esper.util.SimpleTypeParserFactory;
import java.lang.reflect.Array;
import org.w3c.dom.Node;

public class DOMConvertingArrayGetter
implements EventPropertyGetterSPI {
    private final DOMPropertyGetter getter;
    private final Class componentType;
    private final SimpleTypeParser parser;

    public DOMConvertingArrayGetter(DOMPropertyGetter domPropertyGetter, Class returnType) {
        this.getter = domPropertyGetter;
        this.componentType = returnType;
        this.parser = SimpleTypeParserFactory.getParser(returnType);
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        if (!(obj.getUnderlying() instanceof Node)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type Node");
        }
        Node node = (Node)obj.getUnderlying();
        Node[] result = this.getter.getValueAsNodeArray(node);
        if (result == null) {
            return null;
        }
        return DOMConvertingArrayGetter.getDOMArrayFromNodes(result, this.componentType, this.parser);
    }

    private String getCodegen(CodegenContext context) {
        CodegenMember mComponentType = context.makeAddMember(Class.class, this.componentType);
        CodegenMember mParser = context.makeAddMember(SimpleTypeParser.class, this.parser);
        return context.addMethod(Object.class, Node.class, "node", this.getClass()).declareVar(Node[].class, "result", this.getter.getValueAsNodeArrayCodegen(CodegenExpressionBuilder.ref("node"), context)).ifRefNullReturnNull("result").methodReturn(CodegenExpressionBuilder.staticMethod(this.getClass(), "getDOMArrayFromNodes", CodegenExpressionBuilder.ref("result"), CodegenExpressionBuilder.ref(mComponentType.getMemberName()), CodegenExpressionBuilder.ref(mParser.getMemberName())));
    }

    public static Object getDOMArrayFromNodes(Node[] result, Class componentType, SimpleTypeParser parser) {
        Object array = Array.newInstance(componentType, result.length);
        for (int i = 0; i < result.length; ++i) {
            String text = result[i].getTextContent();
            if (text == null || text.length() == 0) continue;
            Object parseResult = parser.parse(text);
            Array.set(array, i, parseResult);
        }
        return array;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }

    @Override
    public CodegenExpression codegenEventBeanGet(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingGet(CodegenExpressionBuilder.castUnderlying(Node.class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenEventBeanExists(CodegenExpression beanExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenEventBeanFragment(CodegenExpression beanExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression codegenUnderlyingGet(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.localMethod(this.getCodegen(context), underlyingExpression);
    }

    @Override
    public CodegenExpression codegenUnderlyingExists(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenUnderlyingFragment(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantNull();
    }
}

