/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.codegen.core.CodegenContext;
import com.espertech.esper.codegen.core.CodegenMember;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.xml.DOMPropertyGetter;
import com.espertech.esper.util.SimpleTypeParser;
import com.espertech.esper.util.SimpleTypeParserFactory;
import org.w3c.dom.Node;

public class DOMConvertingGetter
implements EventPropertyGetterSPI {
    private final DOMPropertyGetter getter;
    private final SimpleTypeParser parser;
    private CodegenMember codegenParser;

    public static Object getParseTextValue(Node node, SimpleTypeParser parser) throws PropertyAccessException {
        if (node == null) {
            return null;
        }
        String text = node.getTextContent();
        if (text == null) {
            return null;
        }
        return parser.parse(text);
    }

    public DOMConvertingGetter(DOMPropertyGetter domPropertyGetter, Class returnType) {
        this.getter = domPropertyGetter;
        this.parser = SimpleTypeParserFactory.getParser(returnType);
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        if (!(obj.getUnderlying() instanceof Node)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type Node");
        }
        Node node = (Node)obj.getUnderlying();
        Node result = this.getter.getValueAsNode(node);
        return DOMConvertingGetter.getParseTextValue(result, this.parser);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }

    @Override
    public CodegenExpression codegenEventBeanGet(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingGet(CodegenExpressionBuilder.castUnderlying(Node.class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenEventBeanExists(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingExists(CodegenExpressionBuilder.castUnderlying(Node.class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenEventBeanFragment(CodegenExpression beanExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression codegenUnderlyingGet(CodegenExpression underlyingExpression, CodegenContext context) {
        this.generateParserMember(context);
        CodegenExpression inner = this.getter.codegenUnderlyingGet(underlyingExpression, context);
        return CodegenExpressionBuilder.staticMethod(this.getClass(), "getParseTextValue", inner, CodegenExpressionBuilder.ref(this.codegenParser.getMemberName()));
    }

    @Override
    public CodegenExpression codegenUnderlyingExists(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenUnderlyingFragment(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantNull();
    }

    private void generateParserMember(CodegenContext context) {
        if (this.codegenParser == null) {
            this.codegenParser = context.makeMember(SimpleTypeParser.class, this.parser);
        }
        context.addMember(this.codegenParser);
    }
}

