/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.codegen.core.CodegenContext;
import com.espertech.esper.codegen.core.CodegenMember;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.xml.FragmentFactory;
import com.espertech.esper.event.xml.SchemaUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleTypeParser;
import com.espertech.esper.util.SimpleTypeParserFactory;
import java.lang.reflect.Array;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathPropertyGetter
implements EventPropertyGetterSPI {
    private static final Logger log = LoggerFactory.getLogger(XPathPropertyGetter.class);
    private final XPathExpression expression;
    private final String expressionText;
    private final String property;
    private final QName resultType;
    private final SimpleTypeParser simpleTypeParser;
    private final Class optionalCastToType;
    private final boolean isCastToArray;
    private final FragmentFactory fragmentFactory;

    public XPathPropertyGetter(String propertyName, String expressionText, XPathExpression xPathExpression, QName resultType, Class optionalCastToType, FragmentFactory fragmentFactory) {
        this.expression = xPathExpression;
        this.expressionText = expressionText;
        this.property = propertyName;
        this.resultType = resultType;
        this.fragmentFactory = fragmentFactory;
        if (optionalCastToType != null && optionalCastToType.isArray()) {
            this.isCastToArray = true;
            if (!resultType.equals(XPathConstants.NODESET)) {
                throw new IllegalArgumentException("Array cast-to types require XPathConstants.NODESET as the XPath result type");
            }
            optionalCastToType = optionalCastToType.getComponentType();
        } else {
            this.isCastToArray = false;
        }
        this.simpleTypeParser = optionalCastToType != null ? SimpleTypeParserFactory.getParser(optionalCastToType) : null;
        this.optionalCastToType = optionalCastToType == Node.class ? null : optionalCastToType;
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object und = eventBean.getUnderlying();
        if (und == null) {
            throw new PropertyAccessException("Unexpected null underlying event encountered, expecting org.w3c.dom.Node instance as underlying");
        }
        if (!(und instanceof Node)) {
            throw new PropertyAccessException("Unexpected underlying event of type '" + und.getClass() + "' encountered, expecting org.w3c.dom.Node as underlying");
        }
        return XPathPropertyGetter.evaluateXPathGet((Node)und, this.expression, this.expressionText, this.property, this.optionalCastToType, this.resultType, this.isCastToArray, this.simpleTypeParser);
    }

    public static Object evaluateXPathGet(Node und, XPathExpression expression, String expressionText, String property, Class optionalCastToType, QName resultType, boolean isCastToArray, SimpleTypeParser simpleTypeParser) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Running XPath '" + expressionText + "' for property '" + property + "' against Node XML :" + SchemaUtil.serialize(und));
            }
            if (optionalCastToType == null) {
                return expression.evaluate(und, resultType);
            }
            Object result = expression.evaluate(und, resultType);
            if (result == null) {
                return null;
            }
            if (isCastToArray) {
                return XPathPropertyGetter.castToArray(result, optionalCastToType, simpleTypeParser, expression);
            }
            if (result instanceof String) {
                try {
                    return simpleTypeParser.parse(result.toString());
                }
                catch (RuntimeException ex) {
                    log.warn("Error parsing XPath property named '" + property + "' expression result '" + result + " as type " + optionalCastToType.getName());
                    return null;
                }
            }
            if (result instanceof Double) {
                try {
                    return JavaClassHelper.coerceBoxed((Number)result, optionalCastToType);
                }
                catch (RuntimeException ex) {
                    log.warn("Error coercing XPath property named '" + property + "' expression result '" + result + " as type " + optionalCastToType.getName());
                    return null;
                }
            }
            if (result instanceof Boolean) {
                if (optionalCastToType != Boolean.class) {
                    log.warn("Error coercing XPath property named '" + property + "' expression result '" + result + " as type " + optionalCastToType.getName());
                    return null;
                }
                return result;
            }
            log.warn("Error processing XPath property named '" + property + "' expression result '" + result + ", not a known type");
            return null;
        }
        catch (XPathExpressionException e) {
            throw new PropertyAccessException("Error getting property " + property, e);
        }
    }

    public static Object evaluateXPathFragment(Object und, XPathExpression expression, String expressionText, String property, FragmentFactory fragmentFactory, QName resultType) {
        try {
            Object result;
            if (log.isDebugEnabled()) {
                log.debug("Running XPath '" + expressionText + "' for property '" + property + "' against Node XML :" + SchemaUtil.serialize((Node)und));
            }
            if ((result = expression.evaluate(und, resultType)) instanceof Node) {
                return fragmentFactory.getEvent((Node)result);
            }
            if (result instanceof NodeList) {
                NodeList nodeList = (NodeList)result;
                EventBean[] events = new EventBean[nodeList.getLength()];
                for (int i = 0; i < events.length; ++i) {
                    events[i] = fragmentFactory.getEvent(nodeList.item(i));
                }
                return events;
            }
            log.warn("Error processing XPath property named '" + property + "' expression result is not of type Node or Nodeset");
            return null;
        }
        catch (XPathExpressionException e) {
            throw new PropertyAccessException("Error getting property " + property, e);
        }
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        if (this.fragmentFactory == null) {
            return null;
        }
        Object und = eventBean.getUnderlying();
        if (und == null) {
            throw new PropertyAccessException("Unexpected null underlying event encountered, expecting org.w3c.dom.Node instance as underlying");
        }
        if (!(und instanceof Node)) {
            throw new PropertyAccessException("Unexpected underlying event of type '" + und.getClass() + "' encountered, expecting org.w3c.dom.Node as underlying");
        }
        return XPathPropertyGetter.evaluateXPathFragment(und, this.expression, this.expressionText, this.property, this.fragmentFactory, this.resultType);
    }

    @Override
    public CodegenExpression codegenEventBeanGet(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingGet(CodegenExpressionBuilder.castUnderlying(Node.class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenEventBeanExists(CodegenExpression beanExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenEventBeanFragment(CodegenExpression beanExpression, CodegenContext context) {
        return this.codegenUnderlyingFragment(CodegenExpressionBuilder.castUnderlying(Node.class, beanExpression), context);
    }

    @Override
    public CodegenExpression codegenUnderlyingGet(CodegenExpression underlyingExpression, CodegenContext context) {
        CodegenMember mExpression = context.makeAddMember(XPathExpression.class, this.expression);
        CodegenMember mExpressionText = context.makeAddMember(String.class, this.expressionText);
        CodegenMember mProperty = context.makeAddMember(String.class, this.property);
        CodegenMember mOptionalCastToType = context.makeAddMember(Class.class, this.optionalCastToType);
        CodegenMember mResultType = context.makeAddMember(QName.class, this.resultType);
        CodegenMember mIsCastToArray = context.makeAddMember(Boolean.TYPE, this.isCastToArray);
        CodegenMember mSimpleTypeParser = context.makeAddMember(SimpleTypeParser.class, this.simpleTypeParser);
        return CodegenExpressionBuilder.staticMethod(XPathPropertyGetter.class, "evaluateXPathGet", underlyingExpression, CodegenExpressionBuilder.ref(mExpression.getMemberName()), CodegenExpressionBuilder.ref(mExpressionText.getMemberName()), CodegenExpressionBuilder.ref(mProperty.getMemberName()), CodegenExpressionBuilder.ref(mOptionalCastToType.getMemberName()), CodegenExpressionBuilder.ref(mResultType.getMemberName()), CodegenExpressionBuilder.ref(mIsCastToArray.getMemberName()), CodegenExpressionBuilder.ref(mSimpleTypeParser.getMemberName()));
    }

    @Override
    public CodegenExpression codegenUnderlyingExists(CodegenExpression underlyingExpression, CodegenContext context) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression codegenUnderlyingFragment(CodegenExpression underlyingExpression, CodegenContext context) {
        if (this.fragmentFactory == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenMember mExpression = context.makeAddMember(XPathExpression.class, this.expression);
        CodegenMember mExpressionText = context.makeAddMember(String.class, this.expressionText);
        CodegenMember mProperty = context.makeAddMember(String.class, this.property);
        CodegenMember mFragmentFactory = context.makeAddMember(FragmentFactory.class, this.fragmentFactory);
        CodegenMember mResultType = context.makeAddMember(QName.class, this.resultType);
        return CodegenExpressionBuilder.staticMethod(XPathPropertyGetter.class, "evaluateXPathFragment", underlyingExpression, CodegenExpressionBuilder.ref(mExpression.getMemberName()), CodegenExpressionBuilder.ref(mExpressionText.getMemberName()), CodegenExpressionBuilder.ref(mProperty.getMemberName()), CodegenExpressionBuilder.ref(mFragmentFactory.getMemberName()), CodegenExpressionBuilder.ref(mResultType.getMemberName()));
    }

    private static Object castToArray(Object result, Class optionalCastToType, SimpleTypeParser simpleTypeParser, XPathExpression expression) {
        if (!(result instanceof NodeList)) {
            return null;
        }
        NodeList nodeList = (NodeList)result;
        Object array = Array.newInstance(optionalCastToType, nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object arrayItem;
            block4: {
                arrayItem = null;
                try {
                    Node item = nodeList.item(i);
                    if (item.getNodeType() != 2 && item.getNodeType() != 1) continue;
                    String textContent = nodeList.item(i).getTextContent();
                    arrayItem = simpleTypeParser.parse(textContent);
                }
                catch (Exception ex) {
                    if (!log.isInfoEnabled()) break block4;
                    log.info("Parse error for text content " + nodeList.item(i).getTextContent() + " for expression " + expression);
                }
            }
            Array.set(array, i, arrayItem);
        }
        return array;
    }
}

