/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.filter.FilterSpecParamFilterForEvalDouble;
import com.espertech.esper.pattern.MatchedEventMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterForEvalEventPropIndexedDouble
implements FilterSpecParamFilterForEvalDouble {
    private static final Logger log = LoggerFactory.getLogger(FilterForEvalEventPropIndexedDouble.class);
    private final String resultEventAsName;
    private final int resultEventIndex;
    private final String resultEventProperty;
    private final String statementName;
    private static final long serialVersionUID = -2443484252813342579L;

    public FilterForEvalEventPropIndexedDouble(String resultEventAsName, int resultEventIndex, String resultEventProperty, String statementName) {
        this.resultEventAsName = resultEventAsName;
        this.resultEventIndex = resultEventIndex;
        this.resultEventProperty = resultEventProperty;
        this.statementName = statementName;
    }

    @Override
    public final Double getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] events = (EventBean[])matchedEvents.getMatchingEventAsObjectByTag(this.resultEventAsName);
        if (events == null) {
            log.warn("Matching events for tag '" + this.resultEventAsName + "' returned a null result, using null value in filter criteria, for statement '" + this.statementName + "'");
            return null;
        }
        if (this.resultEventIndex > events.length - 1) {
            log.warn("Matching events for tag '" + this.resultEventAsName + "' returned no result for index " + this.resultEventIndex + " at array length " + events.length + ", using null value in filter criteria, for statement '" + this.statementName + "'");
            return null;
        }
        Number value = (Number)events[this.resultEventIndex].get(this.resultEventProperty);
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    @Override
    public Double getFilterValueDouble(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        return this.getFilterValue(matchedEvents, exprEvaluatorContext);
    }

    public final String toString() {
        return "resultEventProp=" + this.resultEventAsName + '.' + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterForEvalEventPropIndexedDouble)) {
            return false;
        }
        FilterForEvalEventPropIndexedDouble other = (FilterForEvalEventPropIndexedDouble)obj;
        return other.resultEventAsName.equals(this.resultEventAsName) && other.resultEventProperty.equals(this.resultEventProperty) && other.resultEventIndex == this.resultEventIndex;
    }

    public int hashCode() {
        return this.resultEventProperty.hashCode();
    }
}

