/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexLookupableBase;
import com.espertech.esper.filter.FilterSpecLookupable;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterParamIndexCompare
extends FilterParamIndexLookupableBase {
    private final TreeMap<Object, EventEvaluator> constantsMap = new TreeMap();
    private final ReadWriteLock constantsMapRWLock;
    private Double lowerBounds;
    private Double upperBounds;
    private static final Logger log = LoggerFactory.getLogger(FilterParamIndexCompare.class);

    public FilterParamIndexCompare(FilterSpecLookupable lookupable, ReadWriteLock readWriteLock, FilterOperator filterOperator) {
        super(filterOperator, lookupable);
        this.constantsMapRWLock = readWriteLock;
        if (filterOperator != FilterOperator.GREATER && filterOperator != FilterOperator.GREATER_OR_EQUAL && filterOperator != FilterOperator.LESS && filterOperator != FilterOperator.LESS_OR_EQUAL) {
            throw new IllegalArgumentException("Invalid filter operator for index of " + (Object)((Object)filterOperator));
        }
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        return this.constantsMap.get(filterConstant);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator matcher) {
        this.constantsMap.put(filterConstant, matcher);
        Double constant = ((Number)filterConstant).doubleValue();
        if (this.lowerBounds == null || constant < this.lowerBounds) {
            this.lowerBounds = constant;
        }
        if (this.upperBounds == null || constant > this.upperBounds) {
            this.upperBounds = constant;
        }
    }

    @Override
    public final void remove(Object filterConstant) {
        if (this.constantsMap.remove(filterConstant) == null) {
            return;
        }
        this.updateBounds();
    }

    @Override
    public final int sizeExpensive() {
        return this.constantsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.constantsMap.isEmpty();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void matchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        Object propertyValue = this.lookupable.getGetter().get(theEvent);
        if (propertyValue == null) {
            return;
        }
        if (this.lowerBounds == null) {
            return;
        }
        FilterOperator filterOperator = this.getFilterOperator();
        Double propertyValueDouble = ((Number)propertyValue).doubleValue();
        if (filterOperator == FilterOperator.GREATER && propertyValueDouble <= this.lowerBounds) {
            return;
        }
        if (filterOperator == FilterOperator.GREATER_OR_EQUAL && propertyValueDouble < this.lowerBounds) {
            return;
        }
        if (filterOperator == FilterOperator.LESS && propertyValueDouble >= this.upperBounds) {
            return;
        }
        if (filterOperator == FilterOperator.LESS_OR_EQUAL && propertyValueDouble > this.upperBounds) {
            return;
        }
        this.constantsMapRWLock.readLock().lock();
        try {
            EventEvaluator matcher;
            SortedMap<Object, EventEvaluator> subMap = filterOperator == FilterOperator.GREATER || filterOperator == FilterOperator.GREATER_OR_EQUAL ? this.constantsMap.headMap(propertyValue) : this.constantsMap.tailMap(propertyValue);
            EventEvaluator exactEquals = null;
            if (filterOperator == FilterOperator.LESS) {
                exactEquals = this.constantsMap.get(propertyValue);
            }
            for (EventEvaluator matcher2 : subMap.values()) {
                if (exactEquals != null) {
                    exactEquals = null;
                    continue;
                }
                matcher2.matchEvent(theEvent, matches);
            }
            if (filterOperator == FilterOperator.GREATER_OR_EQUAL && (matcher = this.constantsMap.get(propertyValue)) != null) {
                matcher.matchEvent(theEvent, matches);
            }
        }
        finally {
            this.constantsMapRWLock.readLock().unlock();
        }
    }

    private void updateBounds() {
        if (this.constantsMap.isEmpty()) {
            this.lowerBounds = null;
            this.upperBounds = null;
            return;
        }
        this.lowerBounds = ((Number)this.constantsMap.firstKey()).doubleValue();
        this.upperBounds = ((Number)this.constantsMap.lastKey()).doubleValue();
    }
}

