/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filter.DoubleRange;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexDoubleRangeBase;
import com.espertech.esper.filter.FilterSpecLookupable;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterParamIndexDoubleRange
extends FilterParamIndexDoubleRangeBase {
    private static final Logger log = LoggerFactory.getLogger(FilterParamIndexDoubleRange.class);

    public FilterParamIndexDoubleRange(FilterSpecLookupable lookupable, ReadWriteLock readWriteLock, FilterOperator filterOperator) {
        super(lookupable, readWriteLock, filterOperator);
        if (!filterOperator.isRangeOperator()) {
            throw new IllegalArgumentException("Invalid filter operator " + (Object)((Object)filterOperator));
        }
    }

    @Override
    public final void matchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        Object objAttributeValue = this.lookupable.getGetter().get(theEvent);
        if (objAttributeValue == null) {
            return;
        }
        double attributeValue = ((Number)objAttributeValue).doubleValue();
        DoubleRange rangeStart = new DoubleRange(attributeValue - this.largestRangeValueDouble, attributeValue);
        DoubleRange rangeEnd = new DoubleRange(attributeValue, (Double)Double.MAX_VALUE);
        SortedMap subMap = this.ranges.subMap(rangeStart, rangeEnd);
        if (this.getFilterOperator() == FilterOperator.RANGE_OPEN) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue > entry.getKey().getMin()) || !(attributeValue < entry.getKey().getMax())) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_CLOSED) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue >= entry.getKey().getMin()) || !(attributeValue <= entry.getKey().getMax())) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_HALF_CLOSED) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue > entry.getKey().getMin()) || !(attributeValue <= entry.getKey().getMax())) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else if (this.getFilterOperator() == FilterOperator.RANGE_HALF_OPEN) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue >= entry.getKey().getMin()) || !(attributeValue < entry.getKey().getMax())) continue;
                ((EventEvaluator)entry.getValue()).matchEvent(theEvent, matches);
            }
        } else {
            throw new IllegalStateException("Invalid filter operator " + (Object)((Object)this.getFilterOperator()));
        }
    }
}

