/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprConstantNode;
import com.espertech.esper.epl.expression.core.ExprContextPropertyNode;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprFilterOptimizableNode;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.FilterSpecCompilerAdvIndexDescProvider;
import com.espertech.esper.epl.expression.funcs.ExprPlugInSingleRowNode;
import com.espertech.esper.epl.expression.ops.ExprBetweenNode;
import com.espertech.esper.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.epl.expression.ops.ExprInNode;
import com.espertech.esper.epl.expression.ops.ExprInNodeImpl;
import com.espertech.esper.epl.expression.ops.ExprOrNode;
import com.espertech.esper.epl.expression.ops.ExprRelationalOpNode;
import com.espertech.esper.epl.index.quadtree.AdvancedIndexConfigContextPartitionQuadTree;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.NestedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.filter.FilterForEvalConstantAnyType;
import com.espertech.esper.filter.FilterForEvalConstantDouble;
import com.espertech.esper.filter.FilterForEvalConstantString;
import com.espertech.esper.filter.FilterForEvalContextPropDouble;
import com.espertech.esper.filter.FilterForEvalContextPropMayCoerce;
import com.espertech.esper.filter.FilterForEvalContextPropString;
import com.espertech.esper.filter.FilterForEvalEventPropDouble;
import com.espertech.esper.filter.FilterForEvalEventPropIndexedDouble;
import com.espertech.esper.filter.FilterForEvalEventPropIndexedMayCoerce;
import com.espertech.esper.filter.FilterForEvalEventPropMayCoerce;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecCompilerAdvIndexDesc;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecLookupableAdvancedIndex;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamAdvancedIndexQuadTreeMXCIF;
import com.espertech.esper.filter.FilterSpecParamAdvancedIndexQuadTreePointRegion;
import com.espertech.esper.filter.FilterSpecParamConstant;
import com.espertech.esper.filter.FilterSpecParamContextProp;
import com.espertech.esper.filter.FilterSpecParamEventProp;
import com.espertech.esper.filter.FilterSpecParamEventPropIndexed;
import com.espertech.esper.filter.FilterSpecParamFilterForEval;
import com.espertech.esper.filter.FilterSpecParamFilterForEvalDouble;
import com.espertech.esper.filter.FilterSpecParamIn;
import com.espertech.esper.filter.FilterSpecParamInValue;
import com.espertech.esper.filter.FilterSpecParamRange;
import com.espertech.esper.spatial.quadtree.mxcif.XYWHRectangle;
import com.espertech.esper.spatial.quadtree.pointregion.XYPoint;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public final class FilterSpecCompilerMakeParamUtil {
    protected static FilterSpecParam makeFilterParam(ExprNode constituent, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) throws ExprValidationException {
        FilterSpecParam param;
        if ((constituent instanceof ExprEqualsNode || constituent instanceof ExprRelationalOpNode) && (param = FilterSpecCompilerMakeParamUtil.handleEqualsAndRelOp(constituent, arrayEventTypes, exprEvaluatorContext, statementName)) != null) {
            return param;
        }
        if ((constituent = FilterSpecCompilerMakeParamUtil.rewriteOrToInIfApplicable(constituent)) instanceof ExprInNode && (param = FilterSpecCompilerMakeParamUtil.handleInSetNode((ExprInNode)constituent, arrayEventTypes, exprEvaluatorContext, statementName)) != null) {
            return param;
        }
        if (constituent instanceof ExprBetweenNode && (param = FilterSpecCompilerMakeParamUtil.handleRangeNode((ExprBetweenNode)constituent, arrayEventTypes, exprEvaluatorContext, statementName)) != null) {
            return param;
        }
        if (constituent instanceof ExprPlugInSingleRowNode && (param = FilterSpecCompilerMakeParamUtil.handlePlugInSingleRow((ExprPlugInSingleRowNode)constituent)) != null) {
            return param;
        }
        if (constituent instanceof FilterSpecCompilerAdvIndexDescProvider && (param = FilterSpecCompilerMakeParamUtil.handleAdvancedIndexDescProvider((FilterSpecCompilerAdvIndexDescProvider)((Object)constituent), arrayEventTypes, statementName, exprEvaluatorContext)) != null) {
            return param;
        }
        return null;
    }

    private static FilterSpecParam handleAdvancedIndexDescProvider(FilterSpecCompilerAdvIndexDescProvider provider, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, String statementName, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        Class returnType;
        FilterSpecCompilerAdvIndexDesc filterDesc = provider.getFilterSpecDesc();
        if (filterDesc == null) {
            return null;
        }
        ExprNode[] keyExpressions = filterDesc.getKeyExpressions();
        EventPropertyGetter xGetter = FilterSpecCompilerMakeParamUtil.resolveFilterIndexRequiredGetter(filterDesc.getIndexName(), keyExpressions[0]);
        EventPropertyGetter yGetter = FilterSpecCompilerMakeParamUtil.resolveFilterIndexRequiredGetter(filterDesc.getIndexName(), keyExpressions[1]);
        EventPropertyGetter widthGetter = FilterSpecCompilerMakeParamUtil.resolveFilterIndexRequiredGetter(filterDesc.getIndexName(), keyExpressions[2]);
        EventPropertyGetter heightGetter = FilterSpecCompilerMakeParamUtil.resolveFilterIndexRequiredGetter(filterDesc.getIndexName(), keyExpressions[3]);
        AdvancedIndexConfigContextPartitionQuadTree config = (AdvancedIndexConfigContextPartitionQuadTree)filterDesc.getIndexSpec();
        StringWriter builder = new StringWriter();
        ExprNodeUtility.toExpressionString(keyExpressions[0], builder);
        builder.append(",");
        ExprNodeUtility.toExpressionString(keyExpressions[1], builder);
        builder.append(",");
        ExprNodeUtility.toExpressionString(keyExpressions[2], builder);
        builder.append(",");
        ExprNodeUtility.toExpressionString(keyExpressions[3], builder);
        builder.append("/");
        builder.append(filterDesc.getIndexName().toLowerCase(Locale.ENGLISH));
        builder.append("/");
        builder.append(filterDesc.getIndexType().toLowerCase(Locale.ENGLISH));
        builder.append("/");
        config.toConfiguration(builder);
        String expression = builder.toString();
        switch (filterDesc.getIndexType()) {
            case "pointregionquadtree": {
                returnType = XYPoint.class;
                break;
            }
            case "mxcifquadtree": {
                returnType = XYWHRectangle.class;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized index type " + filterDesc.getIndexType());
            }
        }
        FilterSpecLookupableAdvancedIndex lookupable = new FilterSpecLookupableAdvancedIndex(expression, null, returnType, config, xGetter, yGetter, widthGetter, heightGetter, filterDesc.getIndexType());
        ExprNode[] indexExpressions = filterDesc.getIndexExpressions();
        FilterSpecParamFilterForEvalDouble xEval = FilterSpecCompilerMakeParamUtil.resolveFilterIndexDoubleEval(filterDesc.getIndexName(), indexExpressions[0], arrayEventTypes, statementName, exprEvaluatorContext);
        FilterSpecParamFilterForEvalDouble yEval = FilterSpecCompilerMakeParamUtil.resolveFilterIndexDoubleEval(filterDesc.getIndexName(), indexExpressions[1], arrayEventTypes, statementName, exprEvaluatorContext);
        switch (filterDesc.getIndexType()) {
            case "pointregionquadtree": {
                return new FilterSpecParamAdvancedIndexQuadTreePointRegion(lookupable, FilterOperator.ADVANCED_INDEX, xEval, yEval);
            }
            case "mxcifquadtree": {
                FilterSpecParamFilterForEvalDouble widthEval = FilterSpecCompilerMakeParamUtil.resolveFilterIndexDoubleEval(filterDesc.getIndexName(), indexExpressions[2], arrayEventTypes, statementName, exprEvaluatorContext);
                FilterSpecParamFilterForEvalDouble heightEval = FilterSpecCompilerMakeParamUtil.resolveFilterIndexDoubleEval(filterDesc.getIndexName(), indexExpressions[3], arrayEventTypes, statementName, exprEvaluatorContext);
                return new FilterSpecParamAdvancedIndexQuadTreeMXCIF(lookupable, FilterOperator.ADVANCED_INDEX, xEval, yEval, widthEval, heightEval);
            }
        }
        throw new IllegalStateException("Unrecognized index type " + filterDesc.getIndexType());
    }

    private static FilterSpecParamFilterForEvalDouble resolveFilterIndexDoubleEval(String indexName, ExprNode indexExpression, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, String statementName, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        FilterSpecParamFilterForEvalDouble resolved = null;
        if (indexExpression instanceof ExprIdentNode) {
            resolved = FilterSpecCompilerMakeParamUtil.getIdentNodeDoubleEval((ExprIdentNode)indexExpression, arrayEventTypes, statementName);
        } else if (indexExpression instanceof ExprContextPropertyNode) {
            ExprContextPropertyNode node = (ExprContextPropertyNode)indexExpression;
            resolved = new FilterForEvalContextPropDouble(node.getGetter(), node.getPropertyName());
        } else if (ExprNodeUtility.isConstantValueExpr(indexExpression)) {
            ExprConstantNode constantNode = (ExprConstantNode)indexExpression;
            double d = ((Number)constantNode.getConstantValue(exprEvaluatorContext)).doubleValue();
            resolved = new FilterForEvalConstantDouble(d);
        }
        if (resolved != null) {
            return resolved;
        }
        throw new ExprValidationException("Invalid filter-indexable expression '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(indexExpression) + "' in respect to index '" + indexName + "': expected either a constant, context-builtin or property from a previous pattern match");
    }

    private static EventPropertyGetter resolveFilterIndexRequiredGetter(String indexName, ExprNode keyExpression) throws ExprValidationException {
        if (!(keyExpression instanceof ExprIdentNode)) {
            throw new ExprValidationException("Invalid filter-index lookup expression '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(keyExpression) + "' in respect to index '" + indexName + "': expected an event property name");
        }
        return ((ExprIdentNode)keyExpression).getExprEvaluatorIdent().getGetter();
    }

    public static ExprNode rewriteOrToInIfApplicable(ExprNode constituent) {
        ExprNode commonExpressionNode;
        ExprNode rhs;
        ExprNode[] childNodes;
        if (!(constituent instanceof ExprOrNode) || constituent.getChildNodes().length < 2) {
            return constituent;
        }
        for (ExprNode child : childNodes = constituent.getChildNodes()) {
            if (!(child instanceof ExprEqualsNode)) {
                return constituent;
            }
            ExprEqualsNode equalsNode = (ExprEqualsNode)child;
            if (!equalsNode.isIs() && !equalsNode.isNotEquals()) continue;
            return constituent;
        }
        ExprNode lhs = childNodes[0].getChildNodes()[0];
        if (ExprNodeUtility.deepEquals(lhs, rhs = childNodes[0].getChildNodes()[1], false)) {
            return constituent;
        }
        if (FilterSpecCompilerMakeParamUtil.isExprExistsInAllEqualsChildNodes(childNodes, lhs)) {
            commonExpressionNode = lhs;
        } else if (FilterSpecCompilerMakeParamUtil.isExprExistsInAllEqualsChildNodes(childNodes, rhs)) {
            commonExpressionNode = rhs;
        } else {
            return constituent;
        }
        ExprInNodeImpl in = new ExprInNodeImpl(false);
        in.addChildNode(commonExpressionNode);
        for (int i = 0; i < constituent.getChildNodes().length; ++i) {
            ExprNode child = constituent.getChildNodes()[i];
            int nodeindex = ExprNodeUtility.deepEquals(commonExpressionNode, childNodes[i].getChildNodes()[0], false) ? 1 : 0;
            in.addChildNode(child.getChildNodes()[nodeindex]);
        }
        try {
            in.validateWithoutContext();
        }
        catch (ExprValidationException ex) {
            return constituent;
        }
        return in;
    }

    private static FilterSpecParam handlePlugInSingleRow(ExprPlugInSingleRowNode constituent) {
        if (JavaClassHelper.getBoxedType(constituent.getExprEvaluator().getType()) != Boolean.class) {
            return null;
        }
        if (!constituent.getFilterLookupEligible()) {
            return null;
        }
        FilterSpecLookupable lookupable = constituent.getFilterLookupable();
        return new FilterSpecParamConstant(lookupable, FilterOperator.EQUAL, true);
    }

    private static FilterSpecParam handleRangeNode(ExprBetweenNode betweenNode, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) {
        ExprNode left = betweenNode.getChildNodes()[0];
        if (left instanceof ExprFilterOptimizableNode) {
            ExprFilterOptimizableNode filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left);
            FilterSpecLookupable lookupable = filterOptimizableNode.getFilterLookupable();
            FilterOperator op = FilterOperator.parseRangeOperator(betweenNode.isLowEndpointIncluded(), betweenNode.isHighEndpointIncluded(), betweenNode.isNotBetween());
            FilterSpecParamFilterForEval low = FilterSpecCompilerMakeParamUtil.handleRangeNodeEndpoint(betweenNode.getChildNodes()[1], arrayEventTypes, exprEvaluatorContext, statementName);
            FilterSpecParamFilterForEval high = FilterSpecCompilerMakeParamUtil.handleRangeNodeEndpoint(betweenNode.getChildNodes()[2], arrayEventTypes, exprEvaluatorContext, statementName);
            if (low != null && high != null) {
                return new FilterSpecParamRange(lookupable, op, low, high);
            }
        }
        return null;
    }

    private static FilterSpecParamFilterForEval handleRangeNodeEndpoint(ExprNode endpoint, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) {
        if (ExprNodeUtility.isConstantValueExpr(endpoint)) {
            ExprConstantNode node = (ExprConstantNode)endpoint;
            Object value = node.getConstantValue(exprEvaluatorContext);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return new FilterForEvalConstantString((String)value);
            }
            return new FilterForEvalConstantDouble(((Number)value).doubleValue());
        }
        if (endpoint instanceof ExprContextPropertyNode) {
            ExprContextPropertyNode node = (ExprContextPropertyNode)endpoint;
            if (JavaClassHelper.isImplementsCharSequence(node.getType())) {
                return new FilterForEvalContextPropString(node.getGetter(), node.getPropertyName());
            }
            return new FilterForEvalContextPropDouble(node.getGetter(), node.getPropertyName());
        }
        if (endpoint instanceof ExprIdentNode) {
            return FilterSpecCompilerMakeParamUtil.getIdentNodeDoubleEval((ExprIdentNode)endpoint, arrayEventTypes, statementName);
        }
        return null;
    }

    private static FilterSpecParam handleInSetNode(ExprInNode constituent, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) throws ExprValidationException {
        ExprNode left = constituent.getChildNodes()[0];
        if (!(left instanceof ExprFilterOptimizableNode)) {
            return null;
        }
        ExprFilterOptimizableNode filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left);
        FilterSpecLookupable lookupable = filterOptimizableNode.getFilterLookupable();
        FilterOperator op = FilterOperator.IN_LIST_OF_VALUES;
        if (constituent.isNotIn()) {
            op = FilterOperator.NOT_IN_LIST_OF_VALUES;
        }
        int expectedNumberOfConstants = constituent.getChildNodes().length - 1;
        ArrayList<FilterSpecParamInValue> listofValues = new ArrayList<FilterSpecParamInValue>();
        Iterator<ExprNode> it = Arrays.asList(constituent.getChildNodes()).iterator();
        it.next();
        while (it.hasNext()) {
            FilterSpecParamInValue inValue;
            ExprNode subNode = it.next();
            if (ExprNodeUtility.isConstantValueExpr(subNode)) {
                ExprConstantNode constantNode = (ExprConstantNode)subNode;
                Object constant = constantNode.getConstantValue(exprEvaluatorContext);
                if (constant instanceof Collection) {
                    return null;
                }
                if (constant instanceof Map) {
                    return null;
                }
                if (constant != null && constant.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(constant); ++i) {
                        Object arrayElement = Array.get(constant, i);
                        Object arrayElementCoerced = FilterSpecCompilerMakeParamUtil.handleConstantsCoercion(lookupable, arrayElement);
                        listofValues.add(new FilterForEvalConstantAnyType(arrayElementCoerced));
                        if (i <= 0) continue;
                        ++expectedNumberOfConstants;
                    }
                } else {
                    constant = FilterSpecCompilerMakeParamUtil.handleConstantsCoercion(lookupable, constant);
                    listofValues.add(new FilterForEvalConstantAnyType(constant));
                }
            }
            if (subNode instanceof ExprContextPropertyNode) {
                SimpleNumberCoercer coercer;
                ExprContextPropertyNode contextPropertyNode = (ExprContextPropertyNode)subNode;
                Class returnType = contextPropertyNode.getType();
                if (JavaClassHelper.isCollectionMapOrArray(returnType)) {
                    FilterSpecCompilerMakeParamUtil.checkArrayCoercion(returnType, lookupable.getReturnType(), lookupable.getExpression());
                    coercer = null;
                } else {
                    coercer = FilterSpecCompilerMakeParamUtil.getNumberCoercer(left.getExprEvaluator().getType(), contextPropertyNode.getType(), lookupable.getExpression());
                }
                Class finalReturnType = coercer != null ? coercer.getReturnType() : returnType;
                listofValues.add(new FilterForEvalContextPropMayCoerce(contextPropertyNode.getPropertyName(), contextPropertyNode.getGetter(), coercer, finalReturnType));
            }
            if (!(subNode instanceof ExprIdentNode)) continue;
            ExprIdentNode identNodeInner = (ExprIdentNode)subNode;
            if (identNodeInner.getStreamId() == 0) break;
            boolean isMustCoerce = false;
            Class coerceToType = JavaClassHelper.getBoxedType(lookupable.getReturnType());
            Class identReturnType = identNodeInner.getExprEvaluator().getType();
            if (JavaClassHelper.isCollectionMapOrArray(identReturnType)) {
                FilterSpecCompilerMakeParamUtil.checkArrayCoercion(identReturnType, lookupable.getReturnType(), lookupable.getExpression());
                coerceToType = identReturnType;
            } else if (identReturnType != lookupable.getReturnType()) {
                if (!JavaClassHelper.isNumeric(lookupable.getReturnType())) break;
                if (!JavaClassHelper.canCoerce(identReturnType, lookupable.getReturnType())) {
                    FilterSpecCompilerMakeParamUtil.throwConversionError(identReturnType, lookupable.getReturnType(), lookupable.getExpression());
                }
                isMustCoerce = true;
            }
            String streamName = identNodeInner.getResolvedStreamName();
            if (arrayEventTypes != null && !arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(streamName)) {
                Pair<Integer, String> indexAndProp = FilterSpecCompilerMakeParamUtil.getStreamIndex(identNodeInner.getResolvedPropertyName());
                inValue = new FilterForEvalEventPropIndexedMayCoerce(identNodeInner.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), isMustCoerce, coerceToType, statementName);
            } else {
                inValue = new FilterForEvalEventPropMayCoerce(identNodeInner.getResolvedStreamName(), identNodeInner.getResolvedPropertyName(), isMustCoerce, coerceToType);
            }
            listofValues.add(inValue);
        }
        if (listofValues.size() == expectedNumberOfConstants) {
            return new FilterSpecParamIn(lookupable, op, listofValues);
        }
        return null;
    }

    private static void checkArrayCoercion(Class returnTypeValue, Class returnTypeLookupable, String propertyName) throws ExprValidationException {
        if (returnTypeValue == null || !returnTypeValue.isArray()) {
            return;
        }
        if (!JavaClassHelper.isArrayTypeCompatible(returnTypeLookupable, returnTypeValue.getComponentType())) {
            FilterSpecCompilerMakeParamUtil.throwConversionError(returnTypeValue.getComponentType(), returnTypeLookupable, propertyName);
        }
    }

    private static FilterSpecParam handleEqualsAndRelOp(ExprNode constituent, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) throws ExprValidationException {
        FilterSpecLookupable lookupable;
        ExprContextPropertyNode ctxNode;
        ExprFilterOptimizableNode filterOptimizableNode;
        FilterOperator op;
        if (constituent instanceof ExprEqualsNode) {
            ExprEqualsNode equalsNode = (ExprEqualsNode)constituent;
            if (!equalsNode.isIs()) {
                op = FilterOperator.EQUAL;
                if (equalsNode.isNotEquals()) {
                    op = FilterOperator.NOT_EQUAL;
                }
            } else {
                op = FilterOperator.IS;
                if (equalsNode.isNotEquals()) {
                    op = FilterOperator.IS_NOT;
                }
            }
        } else {
            ExprRelationalOpNode relNode = (ExprRelationalOpNode)constituent;
            if (relNode.getRelationalOpEnum() == RelationalOpEnum.GT) {
                op = FilterOperator.GREATER;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.LT) {
                op = FilterOperator.LESS;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.LE) {
                op = FilterOperator.LESS_OR_EQUAL;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.GE) {
                op = FilterOperator.GREATER_OR_EQUAL;
            } else {
                throw new IllegalStateException("Opertor '" + (Object)((Object)relNode.getRelationalOpEnum()) + "' not mapped");
            }
        }
        ExprNode left = constituent.getChildNodes()[0];
        ExprNode right = constituent.getChildNodes()[1];
        if (ExprNodeUtility.isConstantValueExpr(right) && left instanceof ExprFilterOptimizableNode && (filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left)).getFilterLookupEligible()) {
            ExprConstantNode constantNode = (ExprConstantNode)right;
            FilterSpecLookupable lookupable2 = filterOptimizableNode.getFilterLookupable();
            Object constant = constantNode.getConstantValue(exprEvaluatorContext);
            constant = FilterSpecCompilerMakeParamUtil.handleConstantsCoercion(lookupable2, constant);
            return new FilterSpecParamConstant(lookupable2, op, constant);
        }
        if (ExprNodeUtility.isConstantValueExpr(left) && right instanceof ExprFilterOptimizableNode && (filterOptimizableNode = (ExprFilterOptimizableNode)((Object)right)).getFilterLookupEligible()) {
            ExprConstantNode constantNode = (ExprConstantNode)left;
            FilterSpecLookupable lookupable3 = filterOptimizableNode.getFilterLookupable();
            Object constant = constantNode.getConstantValue(exprEvaluatorContext);
            constant = FilterSpecCompilerMakeParamUtil.handleConstantsCoercion(lookupable3, constant);
            FilterOperator opReversed = op.isComparisonOperator() ? op.reversedRelationalOp() : op;
            return new FilterSpecParamConstant(lookupable3, opReversed, constant);
        }
        if (left instanceof ExprIdentNode && right instanceof ExprIdentNode) {
            ExprIdentNode identNodeLeft = (ExprIdentNode)left;
            ExprIdentNode identNodeRight = (ExprIdentNode)right;
            if (identNodeLeft.getStreamId() == 0 && identNodeLeft.getFilterLookupEligible() && identNodeRight.getStreamId() != 0) {
                return FilterSpecCompilerMakeParamUtil.handleProperty(op, identNodeLeft, identNodeRight, arrayEventTypes, statementName);
            }
            if (identNodeRight.getStreamId() == 0 && identNodeRight.getFilterLookupEligible() && identNodeLeft.getStreamId() != 0) {
                op = FilterSpecCompilerMakeParamUtil.getReversedOperator(constituent, op);
                return FilterSpecCompilerMakeParamUtil.handleProperty(op, identNodeRight, identNodeLeft, arrayEventTypes, statementName);
            }
        }
        if (left instanceof ExprFilterOptimizableNode && right instanceof ExprContextPropertyNode) {
            filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left);
            ctxNode = (ExprContextPropertyNode)right;
            lookupable = filterOptimizableNode.getFilterLookupable();
            if (filterOptimizableNode.getFilterLookupEligible()) {
                SimpleNumberCoercer numberCoercer = FilterSpecCompilerMakeParamUtil.getNumberCoercer(lookupable.getReturnType(), ctxNode.getType(), lookupable.getExpression());
                return new FilterSpecParamContextProp(lookupable, op, ctxNode.getPropertyName(), ctxNode.getGetter(), numberCoercer);
            }
        }
        if (left instanceof ExprContextPropertyNode && right instanceof ExprFilterOptimizableNode) {
            filterOptimizableNode = (ExprFilterOptimizableNode)((Object)right);
            ctxNode = (ExprContextPropertyNode)left;
            lookupable = filterOptimizableNode.getFilterLookupable();
            if (filterOptimizableNode.getFilterLookupEligible()) {
                op = FilterSpecCompilerMakeParamUtil.getReversedOperator(constituent, op);
                SimpleNumberCoercer numberCoercer = FilterSpecCompilerMakeParamUtil.getNumberCoercer(lookupable.getReturnType(), ctxNode.getType(), lookupable.getExpression());
                return new FilterSpecParamContextProp(lookupable, op, ctxNode.getPropertyName(), ctxNode.getGetter(), numberCoercer);
            }
        }
        return null;
    }

    private static FilterOperator getReversedOperator(ExprNode constituent, FilterOperator op) {
        if (!(constituent instanceof ExprRelationalOpNode)) {
            return op;
        }
        ExprRelationalOpNode relNode = (ExprRelationalOpNode)constituent;
        RelationalOpEnum relationalOpEnum = relNode.getRelationalOpEnum();
        if (relationalOpEnum == RelationalOpEnum.GT) {
            return FilterOperator.LESS;
        }
        if (relationalOpEnum == RelationalOpEnum.LT) {
            return FilterOperator.GREATER;
        }
        if (relationalOpEnum == RelationalOpEnum.LE) {
            return FilterOperator.GREATER_OR_EQUAL;
        }
        if (relationalOpEnum == RelationalOpEnum.GE) {
            return FilterOperator.LESS_OR_EQUAL;
        }
        return op;
    }

    private static FilterSpecParam handleProperty(FilterOperator op, ExprIdentNode identNodeLeft, ExprIdentNode identNodeRight, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, String statementName) throws ExprValidationException {
        Class rightType;
        String propertyName = identNodeLeft.getResolvedPropertyName();
        Class leftType = identNodeLeft.getExprEvaluator().getType();
        SimpleNumberCoercer numberCoercer = FilterSpecCompilerMakeParamUtil.getNumberCoercer(leftType, rightType = identNodeRight.getExprEvaluator().getType(), propertyName);
        boolean isMustCoerce = numberCoercer != null;
        Class numericCoercionType = JavaClassHelper.getBoxedType(leftType);
        String streamName = identNodeRight.getResolvedStreamName();
        if (arrayEventTypes != null && !arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(streamName)) {
            Pair<Integer, String> indexAndProp = FilterSpecCompilerMakeParamUtil.getStreamIndex(identNodeRight.getResolvedPropertyName());
            return new FilterSpecParamEventPropIndexed(identNodeLeft.getFilterLookupable(), op, identNodeRight.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), isMustCoerce, numberCoercer, numericCoercionType, statementName);
        }
        return new FilterSpecParamEventProp(identNodeLeft.getFilterLookupable(), op, identNodeRight.getResolvedStreamName(), identNodeRight.getResolvedPropertyName(), isMustCoerce, numberCoercer, numericCoercionType, statementName);
    }

    private static SimpleNumberCoercer getNumberCoercer(Class leftType, Class rightType, String expression) throws ExprValidationException {
        Class numericCoercionType = JavaClassHelper.getBoxedType(leftType);
        if (rightType != leftType && JavaClassHelper.isNumeric(rightType)) {
            if (!JavaClassHelper.canCoerce(rightType, leftType)) {
                FilterSpecCompilerMakeParamUtil.throwConversionError(rightType, leftType, expression);
            }
            return SimpleNumberCoercerFactory.getCoercer(rightType, numericCoercionType);
        }
        return null;
    }

    private static Pair<Integer, String> getStreamIndex(String resolvedPropertyName) {
        Property property = PropertyParser.parseAndWalkLaxToSimple(resolvedPropertyName);
        if (!(property instanceof NestedProperty)) {
            throw new IllegalStateException("Expected a nested property providing an index for array match '" + resolvedPropertyName + "'");
        }
        NestedProperty nested = (NestedProperty)property;
        if (nested.getProperties().size() < 2) {
            throw new IllegalStateException("Expected a nested property name for array match '" + resolvedPropertyName + "', none found");
        }
        if (!(nested.getProperties().get(0) instanceof IndexedProperty)) {
            throw new IllegalStateException("Expected an indexed property for array match '" + resolvedPropertyName + "', please provide an index");
        }
        int index = ((IndexedProperty)nested.getProperties().get(0)).getIndex();
        nested.getProperties().remove(0);
        StringWriter writer = new StringWriter();
        nested.toPropertyEPL(writer);
        return new Pair<Integer, String>(index, writer.toString());
    }

    private static void throwConversionError(Class fromType, Class toType, String propertyName) throws ExprValidationException {
        String text = "Implicit conversion from datatype '" + fromType.getSimpleName() + "' to '" + toType.getSimpleName() + "' for property '" + propertyName + "' is not allowed (strict filter type coercion)";
        throw new ExprValidationException(text);
    }

    private static Object handleConstantsCoercion(FilterSpecLookupable lookupable, Object constant) throws ExprValidationException {
        Class identNodeType = lookupable.getReturnType();
        if (!JavaClassHelper.isNumeric(identNodeType)) {
            return constant;
        }
        if (constant == null) {
            return null;
        }
        if (!JavaClassHelper.canCoerce(constant.getClass(), identNodeType)) {
            FilterSpecCompilerMakeParamUtil.throwConversionError(constant.getClass(), identNodeType, lookupable.getExpression());
        }
        Class identNodeTypeBoxed = JavaClassHelper.getBoxedType(identNodeType);
        return JavaClassHelper.coerceBoxed((Number)constant, identNodeTypeBoxed);
    }

    private static boolean isExprExistsInAllEqualsChildNodes(ExprNode[] childNodes, ExprNode search) {
        for (ExprNode child : childNodes) {
            ExprNode lhs = child.getChildNodes()[0];
            ExprNode rhs = child.getChildNodes()[1];
            if (!ExprNodeUtility.deepEquals(lhs, search, false) && !ExprNodeUtility.deepEquals(rhs, search, false)) {
                return false;
            }
            if (!ExprNodeUtility.deepEquals(lhs, rhs, false)) continue;
            return false;
        }
        return true;
    }

    private static FilterSpecParamFilterForEvalDouble getIdentNodeDoubleEval(ExprIdentNode node, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, String statementName) {
        if (node.getStreamId() == 0) {
            return null;
        }
        if (arrayEventTypes != null && !arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(node.getResolvedStreamName())) {
            Pair<Integer, String> indexAndProp = FilterSpecCompilerMakeParamUtil.getStreamIndex(node.getResolvedPropertyName());
            return new FilterForEvalEventPropIndexedDouble(node.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), statementName);
        }
        return new FilterForEvalEventPropDouble(node.getResolvedStreamName(), node.getResolvedPropertyName());
    }
}

