/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.collection.CombinationEnumeration;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprAndNode;
import com.espertech.esper.epl.expression.ops.ExprOrNode;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeTableAccessFinderVisitor;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamExprMap;
import com.espertech.esper.filter.FilterSpecCompilerArgs;
import com.espertech.esper.filter.FilterSpecCompilerConsolidateUtil;
import com.espertech.esper.filter.FilterSpecCompilerMakeParamUtil;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamExprNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class FilterSpecCompilerPlanner {
    protected static List<FilterSpecParam>[] planFilterParameters(List<ExprNode> validatedNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        if (validatedNodes.isEmpty()) {
            return FilterSpecCompilerPlanner.allocateListArray(0);
        }
        FilterParamExprMap filterParamExprMap = new FilterParamExprMap();
        FilterSpecCompilerPlanner.decomposePopulateConsolidate(filterParamExprMap, validatedNodes, args);
        ArrayList<FilterSpecParam> filterParams = new ArrayList<FilterSpecParam>();
        filterParams.addAll(filterParamExprMap.getFilterParams());
        int countUnassigned = filterParamExprMap.countUnassignedExpressions();
        if (countUnassigned == 0) {
            return FilterSpecCompilerPlanner.allocateListArraySizeOne(filterParams);
        }
        int filterServiceMaxFilterWidth = args.configurationInformation.getEngineDefaults().getExecution().getFilterServiceMaxFilterWidth();
        Hint hint = HintEnum.MAX_FILTER_WIDTH.getHint(args.annotations);
        if (hint != null) {
            String hintValue = HintEnum.MAX_FILTER_WIDTH.getHintAssignedValue(hint);
            filterServiceMaxFilterWidth = Integer.parseInt(hintValue);
        }
        List<FilterSpecParam>[] plan = null;
        if (filterServiceMaxFilterWidth > 0) {
            plan = FilterSpecCompilerPlanner.planRemainingNodesIfFeasible(filterParamExprMap, args, filterServiceMaxFilterWidth);
        }
        if (plan != null) {
            return plan;
        }
        FilterSpecParamExprNode node = FilterSpecCompilerPlanner.makeRemainingNode(filterParamExprMap.getUnassignedExpressions(), args);
        filterParams.add(node);
        return FilterSpecCompilerPlanner.allocateListArraySizeOne(filterParams);
    }

    private static List<FilterSpecParam>[] planRemainingNodesIfFeasible(FilterParamExprMap overallExpressions, FilterSpecCompilerArgs args, int filterServiceMaxFilterWidth) throws ExprValidationException {
        List<ExprNode> unassigned = overallExpressions.getUnassignedExpressions();
        ArrayList<ExprOrNode> orNodes = new ArrayList<ExprOrNode>(unassigned.size());
        for (ExprNode node : unassigned) {
            if (!(node instanceof ExprOrNode)) continue;
            orNodes.add((ExprOrNode)node);
        }
        FilterParamExprMap expressionsWithoutOr = new FilterParamExprMap();
        expressionsWithoutOr.add(overallExpressions);
        FilterParamExprMap[][] orNodesMaps = new FilterParamExprMap[orNodes.size()][];
        int countOr = 0;
        int sizeFactorized = 1;
        int[] sizePerOr = new int[orNodes.size()];
        for (ExprOrNode orNode : orNodes) {
            expressionsWithoutOr.removeNode(orNode);
            orNodesMaps[countOr] = new FilterParamExprMap[orNode.getChildNodes().length];
            int len = orNode.getChildNodes().length;
            for (int i = 0; i < len; ++i) {
                FilterParamExprMap map;
                orNodesMaps[countOr][i] = map = new FilterParamExprMap();
                List<ExprNode> nodes = Collections.singletonList(orNode.getChildNodes()[i]);
                FilterSpecCompilerPlanner.decomposePopulateConsolidate(map, nodes, args);
            }
            sizePerOr[countOr] = len;
            sizeFactorized *= len;
            ++countOr;
        }
        if (sizeFactorized > filterServiceMaxFilterWidth) {
            return null;
        }
        List[] result = new List[sizeFactorized];
        CombinationEnumeration permutations = CombinationEnumeration.fromZeroBasedRanges(sizePerOr);
        int count = 0;
        while (permutations.hasMoreElements()) {
            Object[] permutation = permutations.nextElement();
            result[count] = FilterSpecCompilerPlanner.computePermutation(expressionsWithoutOr, permutation, orNodesMaps, args);
            ++count;
        }
        return result;
    }

    private static List<FilterSpecParam> computePermutation(FilterParamExprMap filterParamExprMap, Object[] permutation, FilterParamExprMap[][] orNodesMaps, FilterSpecCompilerArgs args) throws ExprValidationException {
        FilterParamExprMap mapAll = new FilterParamExprMap();
        mapAll.add(filterParamExprMap);
        for (int orNodeNum = 0; orNodeNum < permutation.length; ++orNodeNum) {
            int orChildNodeNum = (Integer)permutation[orNodeNum];
            FilterParamExprMap mapOrSub = orNodesMaps[orNodeNum][orChildNodeNum];
            mapAll.add(mapOrSub);
        }
        FilterSpecCompilerConsolidateUtil.consolidate(mapAll, args.statementName);
        ArrayList<FilterSpecParam> filterParams = new ArrayList<FilterSpecParam>();
        filterParams.addAll(mapAll.getFilterParams());
        int countUnassigned = mapAll.countUnassignedExpressions();
        if (countUnassigned == 0) {
            return filterParams;
        }
        FilterSpecParamExprNode node = FilterSpecCompilerPlanner.makeRemainingNode(mapAll.getUnassignedExpressions(), args);
        filterParams.add(node);
        return filterParams;
    }

    private static void decomposePopulateConsolidate(FilterParamExprMap filterParamExprMap, List<ExprNode> validatedNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        List<ExprNode> constituents = FilterSpecCompilerPlanner.decomposeCheckAggregation(validatedNodes);
        for (ExprNode constituent : constituents) {
            FilterSpecParam param = FilterSpecCompilerMakeParamUtil.makeFilterParam(constituent, args.arrayEventTypes, args.exprEvaluatorContext, args.statementName);
            filterParamExprMap.put(constituent, param);
        }
        FilterSpecCompilerConsolidateUtil.consolidate(filterParamExprMap, args.statementName);
    }

    private static FilterSpecParamExprNode makeRemainingNode(List<ExprNode> unassignedExpressions, FilterSpecCompilerArgs args) throws ExprValidationException {
        if (unassignedExpressions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ExprNode exprNode = unassignedExpressions.size() == 1 ? unassignedExpressions.get(0) : FilterSpecCompilerPlanner.makeValidateAndNode(unassignedExpressions, args);
        return FilterSpecCompilerPlanner.makeBooleanExprParam(exprNode, args);
    }

    private static List<FilterSpecParam>[] allocateListArraySizeOne(List<FilterSpecParam> params) {
        List<FilterSpecParam>[] arr = FilterSpecCompilerPlanner.allocateListArray(1);
        arr[0] = params;
        return arr;
    }

    private static List<FilterSpecParam>[] allocateListArray(int i) {
        return new List[i];
    }

    private static FilterSpecParamExprNode makeBooleanExprParam(ExprNode exprNode, FilterSpecCompilerArgs args) {
        boolean hasSubselectFilterStream = FilterSpecCompilerPlanner.determineSubselectFilterStream(exprNode);
        boolean hasTableAccess = FilterSpecCompilerPlanner.determineTableAccessFilterStream(exprNode);
        FilterSpecLookupable lookupable = new FilterSpecLookupable(".boolean_expression", null, exprNode.getExprEvaluator().getType(), false);
        return new FilterSpecParamExprNode(lookupable, FilterOperator.BOOLEAN_EXPRESSION, exprNode, args.taggedEventTypes, args.arrayEventTypes, args.variableService, args.tableService, args.eventAdapterService, args.filterBooleanExpressionFactory, args.configurationInformation, hasSubselectFilterStream, hasTableAccess);
    }

    private static ExprAndNode makeValidateAndNode(List<ExprNode> remainingExprNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        ExprAndNode andNode = ExprNodeUtility.connectExpressionsByLogicalAnd(remainingExprNodes);
        ExprValidationContext validationContext = new ExprValidationContext(args.streamTypeService, args.engineImportService, args.statementExtensionSvcContext, null, args.timeProvider, args.variableService, args.tableService, args.exprEvaluatorContext, args.eventAdapterService, args.statementName, args.statementId, args.annotations, args.contextDescriptor, false, false, true, false, null, false);
        andNode.validate(validationContext);
        return andNode;
    }

    private static boolean determineTableAccessFilterStream(ExprNode exprNode) {
        ExprNodeTableAccessFinderVisitor visitor = new ExprNodeTableAccessFinderVisitor();
        exprNode.accept(visitor);
        return visitor.isHasTableAccess();
    }

    private static boolean determineSubselectFilterStream(ExprNode exprNode) {
        ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
        exprNode.accept(visitor);
        if (visitor.getSubselects().isEmpty()) {
            return false;
        }
        for (ExprSubselectNode subselectNode : visitor.getSubselects()) {
            if (!subselectNode.isFilterStreamSubselect()) continue;
            return true;
        }
        return false;
    }

    private static List<ExprNode> decomposeCheckAggregation(List<ExprNode> validatedNodes) throws ExprValidationException {
        ArrayList<ExprNode> constituents = new ArrayList<ExprNode>();
        for (ExprNode validated : validatedNodes) {
            if (validated instanceof ExprAndNode) {
                FilterSpecCompilerPlanner.recursiveAndConstituents(constituents, validated);
            } else {
                constituents.add(validated);
            }
            LinkedList<ExprAggregateNode> aggregateExprNodes = new LinkedList<ExprAggregateNode>();
            ExprAggregateNodeUtil.getAggregatesBottomUp(validated, aggregateExprNodes);
            if (aggregateExprNodes.isEmpty()) continue;
            throw new ExprValidationException("Aggregation functions not allowed within filters");
        }
        return constituents;
    }

    private static void recursiveAndConstituents(List<ExprNode> constituents, ExprNode exprNode) {
        for (ExprNode inner : exprNode.getChildNodes()) {
            if (inner instanceof ExprAndNode) {
                FilterSpecCompilerPlanner.recursiveAndConstituents(constituents, inner);
                continue;
            }
            constituents.add(inner);
        }
    }
}

