/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamFilterForEvalDouble;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.spatial.quadtree.mxcif.XYWHRectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterSpecParamAdvancedIndexQuadTreeMXCIF
extends FilterSpecParam {
    private static final Logger log = LoggerFactory.getLogger(FilterSpecParamAdvancedIndexQuadTreeMXCIF.class);
    private FilterSpecParamFilterForEvalDouble xEval;
    private FilterSpecParamFilterForEvalDouble yEval;
    private FilterSpecParamFilterForEvalDouble widthEval;
    private FilterSpecParamFilterForEvalDouble heightEval;

    public FilterSpecParamAdvancedIndexQuadTreeMXCIF(FilterSpecLookupable lookupable, FilterOperator filterOperator, FilterSpecParamFilterForEvalDouble xEval, FilterSpecParamFilterForEvalDouble yEval, FilterSpecParamFilterForEvalDouble widthEval, FilterSpecParamFilterForEvalDouble heightEval) {
        super(lookupable, filterOperator);
        this.xEval = xEval;
        this.yEval = yEval;
        this.widthEval = widthEval;
        this.heightEval = heightEval;
    }

    @Override
    public Object getFilterValue(MatchedEventMap matchedEvents, AgentInstanceContext agentInstanceContext) {
        Double x = this.xEval.getFilterValueDouble(matchedEvents, agentInstanceContext);
        Double y = this.yEval.getFilterValueDouble(matchedEvents, agentInstanceContext);
        Double width = this.widthEval.getFilterValueDouble(matchedEvents, agentInstanceContext);
        Double height = this.heightEval.getFilterValueDouble(matchedEvents, agentInstanceContext);
        return new XYWHRectangle(x, y, width, height);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamAdvancedIndexQuadTreeMXCIF)) {
            return false;
        }
        FilterSpecParamAdvancedIndexQuadTreeMXCIF other = (FilterSpecParamAdvancedIndexQuadTreeMXCIF)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.xEval.equals(other.xEval) && this.yEval.equals(other.yEval) && this.widthEval.equals(other.widthEval) && this.heightEval.equals(other.heightEval);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

