/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamFilterForEvalDouble;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.spatial.quadtree.pointregion.XYPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterSpecParamAdvancedIndexQuadTreePointRegion
extends FilterSpecParam {
    private static final Logger log = LoggerFactory.getLogger(FilterSpecParamAdvancedIndexQuadTreePointRegion.class);
    private FilterSpecParamFilterForEvalDouble xEval;
    private FilterSpecParamFilterForEvalDouble yEval;

    public FilterSpecParamAdvancedIndexQuadTreePointRegion(FilterSpecLookupable lookupable, FilterOperator filterOperator, FilterSpecParamFilterForEvalDouble xEval, FilterSpecParamFilterForEvalDouble yEval) {
        super(lookupable, filterOperator);
        this.xEval = xEval;
        this.yEval = yEval;
    }

    @Override
    public Object getFilterValue(MatchedEventMap matchedEvents, AgentInstanceContext agentInstanceContext) {
        Double x = this.xEval.getFilterValueDouble(matchedEvents, agentInstanceContext);
        Double y = this.yEval.getFilterValueDouble(matchedEvents, agentInstanceContext);
        return new XYPoint(x, y);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamAdvancedIndexQuadTreePointRegion)) {
            return false;
        }
        FilterSpecParamAdvancedIndexQuadTreePointRegion other = (FilterSpecParamAdvancedIndexQuadTreePointRegion)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.xEval.equals(other.xEval) && this.yEval.equals(other.yEval);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

