/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.filter.DoubleRange;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamFilterForEval;
import com.espertech.esper.filter.StringRange;
import com.espertech.esper.pattern.MatchedEventMap;

public final class FilterSpecParamRange
extends FilterSpecParam {
    private final FilterSpecParamFilterForEval min;
    private final FilterSpecParamFilterForEval max;
    private static final long serialVersionUID = -3381167844631490119L;

    public FilterSpecParamRange(FilterSpecLookupable lookupable, FilterOperator filterOperator, FilterSpecParamFilterForEval min, FilterSpecParamFilterForEval max) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        this.min = min;
        this.max = max;
        if (!filterOperator.isRangeOperator() && !filterOperator.isInvertedRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to range filter parameter");
        }
    }

    @Override
    public final Object getFilterValue(MatchedEventMap matchedEvents, AgentInstanceContext agentInstanceContext) {
        if (this.lookupable.getReturnType() == String.class) {
            return new StringRange((String)this.min.getFilterValue(matchedEvents, agentInstanceContext), (String)this.max.getFilterValue(matchedEvents, agentInstanceContext));
        }
        Double begin = (Double)this.min.getFilterValue(matchedEvents, agentInstanceContext);
        Double end = (Double)this.max.getFilterValue(matchedEvents, agentInstanceContext);
        return new DoubleRange(begin, end);
    }

    public FilterSpecParamFilterForEval getMin() {
        return this.min;
    }

    public FilterSpecParamFilterForEval getMax() {
        return this.max;
    }

    @Override
    public final String toString() {
        return super.toString() + "  range=(min=" + this.min.toString() + ",max=" + this.max.toString() + ')';
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamRange)) {
            return false;
        }
        FilterSpecParamRange other = (FilterSpecParamRange)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.min.equals(other.min) && this.max.equals(other.max);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        return result;
    }
}

