/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.metrics.codahale_metrics.metrics.core;

import com.espertech.esper.metrics.codahale_metrics.metrics.core.Clock;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.Histogram;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.Meter;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.Metered;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.MetricName;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.MetricProcessor;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.Sampling;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.Stoppable;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.Summarizable;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.TimerContext;
import com.espertech.esper.metrics.codahale_metrics.metrics.stats.Snapshot;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Timer
implements Metered,
Stoppable,
Sampling,
Summarizable {
    private final TimeUnit durationUnit;
    private final TimeUnit rateUnit;
    private final Meter meter;
    private final Histogram histogram = new Histogram(Histogram.SampleType.BIASED);
    private final Clock clock;

    Timer(ScheduledExecutorService tickThread, TimeUnit durationUnit, TimeUnit rateUnit) {
        this(tickThread, durationUnit, rateUnit, Clock.defaultClock());
    }

    Timer(ScheduledExecutorService tickThread, TimeUnit durationUnit, TimeUnit rateUnit, Clock clock) {
        this.durationUnit = durationUnit;
        this.rateUnit = rateUnit;
        this.meter = new Meter(tickThread, "calls", rateUnit, clock);
        this.clock = clock;
        this.clear();
    }

    public TimeUnit durationUnit() {
        return this.durationUnit;
    }

    @Override
    public TimeUnit rateUnit() {
        return this.rateUnit;
    }

    public void clear() {
        this.histogram.clear();
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.tick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.tick() - startTime);
        }
    }

    public TimerContext time() {
        return new TimerContext(this, this.clock);
    }

    @Override
    public long count() {
        return this.histogram.count();
    }

    @Override
    public double fifteenMinuteRate() {
        return this.meter.fifteenMinuteRate();
    }

    @Override
    public double fiveMinuteRate() {
        return this.meter.fiveMinuteRate();
    }

    @Override
    public double meanRate() {
        return this.meter.meanRate();
    }

    @Override
    public double oneMinuteRate() {
        return this.meter.oneMinuteRate();
    }

    @Override
    public double max() {
        return this.convertFromNS(this.histogram.max());
    }

    @Override
    public double min() {
        return this.convertFromNS(this.histogram.min());
    }

    @Override
    public double mean() {
        return this.convertFromNS(this.histogram.mean());
    }

    @Override
    public double stdDev() {
        return this.convertFromNS(this.histogram.stdDev());
    }

    @Override
    public double sum() {
        return this.convertFromNS(this.histogram.sum());
    }

    @Override
    public Snapshot getSnapshot() {
        double[] values = this.histogram.getSnapshot().getValues();
        double[] converted = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            converted[i] = this.convertFromNS(values[i]);
        }
        return new Snapshot(converted);
    }

    @Override
    public String eventType() {
        return this.meter.eventType();
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.histogram.update(duration);
            this.meter.mark();
        }
    }

    private double convertFromNS(double ns) {
        return ns / (double)TimeUnit.NANOSECONDS.convert(1L, this.durationUnit);
    }

    @Override
    public void stop() {
        this.meter.stop();
    }

    @Override
    public <T> void processWith(MetricProcessor<T> processor, MetricName name, T context) throws Exception {
        processor.processTimer(name, this, context);
    }
}

