/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.pattern.EvalGuardNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternConsumptionUtil;
import com.espertech.esper.pattern.guard.Guard;
import com.espertech.esper.pattern.guard.Quitable;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalGuardStateNode
extends EvalStateNode
implements Evaluator,
Quitable {
    protected EvalGuardNode evalGuardNode;
    protected EvalStateNode activeChildNode;
    protected Guard guard;
    protected MatchedEventMap beginState;
    private static final Logger log = LoggerFactory.getLogger(EvalGuardStateNode.class);

    public EvalGuardStateNode(Evaluator parentNode, EvalGuardNode evalGuardNode) {
        super(parentNode);
        this.evalGuardNode = evalGuardNode;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.beginState)) {
            this.quit();
            this.getParentEvaluator().evaluateFalse(this, true);
        } else if (this.activeChildNode != null) {
            this.activeChildNode.removeMatch(matchEvent);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalGuardNode;
    }

    @Override
    public PatternAgentInstanceContext getContext() {
        return this.evalGuardNode.getContext();
    }

    @Override
    public void start(MatchedEventMap beginState) {
        this.beginState = beginState;
        this.guard = this.evalGuardNode.getFactoryNode().getGuardFactory().makeGuard(this.evalGuardNode.getContext(), beginState, this, null, null);
        this.activeChildNode = this.evalGuardNode.getChildNode().newState(this, null, 0L);
        this.activeChildNode.start(beginState);
        this.guard.startGuard();
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        boolean guardPass;
        boolean haveQuitted;
        boolean bl = haveQuitted = this.activeChildNode == null;
        if (isQuitted) {
            this.activeChildNode = null;
            this.guard.stopGuard();
        }
        if (!haveQuitted && (guardPass = this.guard.inspect(matchEvent))) {
            this.getParentEvaluator().evaluateTrue(matchEvent, this, isQuitted);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        this.activeChildNode = null;
        this.getParentEvaluator().evaluateFalse(this, true);
    }

    @Override
    public final void quit() {
        if (this.activeChildNode == null) {
            return;
        }
        if (this.activeChildNode != null) {
            this.activeChildNode.quit();
            this.guard.stopGuard();
        }
        this.activeChildNode = null;
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitGuard(this.evalGuardNode.getFactoryNode(), this, this.guard);
        if (this.activeChildNode != null) {
            this.activeChildNode.accept(visitor);
        }
    }

    public final String toString() {
        return "EvaluationWitinStateNode activeChildNode=" + this.activeChildNode + " guard=" + this.guard;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    @Override
    public void guardQuit() {
        if (this.activeChildNode != null) {
            this.activeChildNode.quit();
        }
        this.activeChildNode = null;
        this.getParentEvaluator().evaluateFalse(this, true);
    }
}

