/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.pattern.EvalMatchUntilNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeFactoryBase;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternExpressionPrecedenceEnum;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalMatchUntilFactoryNode
extends EvalNodeFactoryBase {
    private static final long serialVersionUID = 5697835058233579562L;
    private ExprNode lowerBounds;
    private ExprNode upperBounds;
    private ExprNode singleBound;
    private transient MatchedEventConvertor convertor;
    private int[] tagsArrayed;
    private static final Logger log = LoggerFactory.getLogger(EvalMatchUntilFactoryNode.class);

    protected EvalMatchUntilFactoryNode(ExprNode lowerBounds, ExprNode upperBounds, ExprNode singleBound) {
        if (singleBound != null && (lowerBounds != null || upperBounds != null)) {
            throw new IllegalArgumentException("Invalid bounds, specify either single bound or range bounds");
        }
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
        this.singleBound = singleBound;
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        EvalNode[] children = EvalNodeUtil.makeEvalNodeChildren(this.getChildNodes(), agentInstanceContext, parentNode);
        return new EvalMatchUntilNode(agentInstanceContext, this, children[0], children.length == 1 ? null : children[1]);
    }

    public int[] getTagsArrayed() {
        return this.tagsArrayed;
    }

    public void setConvertor(MatchedEventConvertor convertor) {
        this.convertor = convertor;
    }

    public ExprNode getLowerBounds() {
        return this.lowerBounds;
    }

    public ExprNode getUpperBounds() {
        return this.upperBounds;
    }

    public ExprNode getSingleBound() {
        return this.singleBound;
    }

    public void setLowerBounds(ExprNode lowerBounds) {
        this.lowerBounds = lowerBounds;
    }

    public void setUpperBounds(ExprNode upperBounds) {
        this.upperBounds = upperBounds;
    }

    public void setSingleBound(ExprNode singleBound) {
        this.singleBound = singleBound;
    }

    public void setTagsArrayedSet(int[] tagsArrayedSet) {
        this.tagsArrayed = tagsArrayedSet;
    }

    public MatchedEventConvertor getConvertor() {
        return this.convertor;
    }

    public final String toString() {
        return "EvalMatchUntilNode children=" + this.getChildNodes().size();
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.singleBound != null) {
            writer.append("[");
            writer.append(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this.singleBound));
            writer.append("] ");
        } else if (this.lowerBounds != null || this.upperBounds != null) {
            writer.append("[");
            if (this.lowerBounds != null) {
                writer.append(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this.lowerBounds));
            }
            writer.append(":");
            if (this.upperBounds != null) {
                writer.append(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this.upperBounds));
            }
            writer.append("] ");
        }
        this.getChildNodes().get(0).toEPL(writer, this.getPrecedence());
        if (this.getChildNodes().size() > 1) {
            writer.append(" until ");
            this.getChildNodes().get(1).toEPL(writer, this.getPrecedence());
        }
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.REPEAT_UNTIL;
    }
}

